/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.item.curiosities.curios.sets.weeping;

import com.google.common.collect.Multimap;
import com.sammy.malum.MalumMod;
import com.sammy.malum.common.data.attachment.SoulWardData;
import com.sammy.malum.common.item.IMalumEventResponder;
import com.sammy.malum.common.item.IVoidItem;
import com.sammy.malum.common.item.curiosities.curios.AbstractMalumCurioItem;
import com.sammy.malum.common.item.curiosities.curios.MalumCurioItem;
import com.sammy.malum.core.helpers.ComponentHelper;
import com.sammy.malum.core.systems.events.ModifySoulWardPropertiesEvent;
import com.sammy.malum.registry.common.MalumAttributes;
import java.util.function.Consumer;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import top.theillusivec4.curios.api.SlotContext;

public class CurioLimitlessBelt
extends MalumCurioItem
implements IMalumEventResponder,
IVoidItem {
    public CurioLimitlessBelt(Item.Properties builder) {
        super(builder, AbstractMalumCurioItem.MalumTrinketType.VOID);
    }

    @Override
    public void addExtraTooltipLines(Consumer<Component> consumer) {
        consumer.accept(ComponentHelper.positiveCurioEffect("soul_ward_complete_absorption", new Object[0]));
        consumer.accept(ComponentHelper.positiveCurioEffect("soul_ward_escalating_integrity", new Object[0]));
    }

    @Override
    public void addAttributeModifiers(Multimap<Holder<Attribute>, AttributeModifier> map, SlotContext slotContext, ItemStack stack) {
        ResourceLocation id = MalumMod.malumPath("belt_of_the_limitless");
        this.addAttributeModifier(map, (Holder<Attribute>)MalumAttributes.SOUL_WARD_CAPACITY, new AttributeModifier(id, 1.0, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL));
        this.addAttributeModifier(map, (Holder<Attribute>)MalumAttributes.SOUL_WARD_RECOVERY_RATE, new AttributeModifier(id, -0.25, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL));
    }

    @Override
    public void modifySoulWardPropertiesEvent(ModifySoulWardPropertiesEvent event, LivingEntity wardedEntity, ItemStack stack) {
        SoulWardData handler = event.getSoulWardHandler();
        double capacity = wardedEntity.getAttributeValue(MalumAttributes.SOUL_WARD_CAPACITY);
        double delta = 1.0 - handler.getSoulWard() / capacity;
        double integrityMultiplier = Mth.lerp((double)delta, (double)0.75, (double)2.0);
        event.setNewIntegrity(event.getNewIntegrity() * integrityMultiplier);
        event.setNewMagicDamageAbsorption(1.0);
        event.setNewPhysicalDamageAbsorption(1.0);
    }
}

