/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.item.curiosities.curios.sets.weeping;

import com.sammy.malum.common.data.attachment.CurioData;
import com.sammy.malum.common.entity.activator.SpiritCollectionActivatorEntity;
import com.sammy.malum.common.item.IMalumEventResponder;
import com.sammy.malum.common.item.IVoidItem;
import com.sammy.malum.common.item.curiosities.curios.AbstractMalumCurioItem;
import com.sammy.malum.common.item.curiosities.curios.MalumCurioItem;
import com.sammy.malum.core.helpers.ComponentHelper;
import com.sammy.malum.registry.common.MalumAttachmentTypes;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.network.chat.Component;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import net.neoforged.neoforge.event.tick.EntityTickEvent;
import team.lodestar.lodestone.helpers.RandomHelper;

public class CurioWatcherNecklace
extends MalumCurioItem
implements IMalumEventResponder,
IVoidItem {
    public CurioWatcherNecklace(Item.Properties builder) {
        super(builder, AbstractMalumCurioItem.MalumTrinketType.VOID);
    }

    @Override
    public void addExtraTooltipLines(Consumer<Component> consumer) {
        consumer.accept(ComponentHelper.positiveCurioEffect("full_health_fake_collection", new Object[0]));
    }

    public void outgoingDamageEvent(LivingDamageEvent.Pre event, LivingEntity attacker, LivingEntity target, ItemStack stack) {
        if (target.getHealth() >= target.getMaxHealth() * 0.9875f) {
            CurioData data = (CurioData)target.getData(MalumAttachmentTypes.CURIO_DATA);
            if (data.watcherNecklaceCooldown == 0) {
                Level level = attacker.level();
                RandomSource random = level.getRandom();
                UUID uuid = attacker.getUUID();
                Vec3 position = target.position().add(0.0, (double)(target.getBbHeight() / 2.0f), 0.0);
                int amount = target instanceof Player ? 2 : 1;
                Vec3 velocity = new Vec3((double)RandomHelper.randomBetween((RandomSource)random, (float)-0.4f, (float)0.4f), (double)RandomHelper.randomBetween((RandomSource)random, (float)0.1f, (float)0.2f), (double)RandomHelper.randomBetween((RandomSource)random, (float)-0.4f, (float)0.4f));
                for (int i = 0; i < amount; ++i) {
                    SpiritCollectionActivatorEntity entity = new SpiritCollectionActivatorEntity(level, uuid, position, velocity);
                    level.addFreshEntity((Entity)entity);
                }
                data.watcherNecklaceCooldown = 400;
            }
        }
    }

    public static void entityTick(EntityTickEvent.Pre event) {
        Entity entity = event.getEntity();
        if (entity instanceof LivingEntity) {
            LivingEntity entity2 = (LivingEntity)entity;
            CurioData data = (CurioData)entity2.getData(MalumAttachmentTypes.CURIO_DATA);
            if (data.watcherNecklaceCooldown > 0) {
                --data.watcherNecklaceCooldown;
            }
        }
    }
}

