/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.item.curiosities.pouch;

import com.sammy.malum.common.data.component.pouch.MalumPouchContentsComponent;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.apache.commons.lang3.math.Fraction;
import team.lodestar.lodestone.helpers.SoundHelper;

public abstract class MalumPouchItem
extends Item {
    protected static final int BAR_COLOR = Mth.color((float)0.4f, (float)0.4f, (float)1.0f);

    public MalumPouchItem(Item.Properties properties) {
        super(properties);
    }

    public abstract MalumPouchContentsComponent getContents(ItemStack var1);

    public abstract MalumPouchContentsComponent emptyContents();

    public abstract void setContents(ItemStack var1, MalumPouchContentsComponent var2);

    public boolean overrideStackedOnOther(ItemStack stack, Slot slot, ClickAction action, Player player) {
        int i;
        if (stack.getCount() != 1 || action != ClickAction.SECONDARY) {
            return false;
        }
        MalumPouchContentsComponent contents = this.getContents(stack);
        if (contents == null) {
            return false;
        }
        ItemStack itemstack = slot.getItem();
        MalumPouchContentsComponent.Mutable mutable = contents.mutable();
        if (itemstack.isEmpty()) {
            this.playRemoveOneSound((Entity)player);
            ItemStack tryRemove = mutable.removeOne();
            if (tryRemove != null) {
                ItemStack removed = slot.safeInsert(tryRemove);
                mutable.tryInsert(removed);
            }
        } else if (itemstack.getItem().canFitInsideContainerItems() && (i = mutable.tryTransfer(slot, player)) > 0) {
            this.playInsertSound((Entity)player);
        }
        this.setContents(stack, mutable.immutable());
        return true;
    }

    public boolean overrideOtherStackedOnMe(ItemStack stack, ItemStack other, Slot slot, ClickAction action, Player player, SlotAccess access) {
        if (stack.getCount() != 1) {
            return false;
        }
        if (action == ClickAction.SECONDARY && slot.allowModification(player)) {
            MalumPouchContentsComponent contents = this.getContents(stack);
            if (contents == null) {
                return false;
            }
            MalumPouchContentsComponent.Mutable mutable = contents.mutable();
            if (other.isEmpty()) {
                ItemStack removed = mutable.removeOne();
                if (removed != null) {
                    this.playRemoveOneSound((Entity)player);
                    access.set(removed);
                }
            } else {
                int i = mutable.tryInsert(other);
                if (i > 0) {
                    this.playInsertSound((Entity)player);
                }
            }
            this.setContents(stack, mutable.immutable());
            return true;
        }
        return false;
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand usedHand) {
        ItemStack itemstack = player.getItemInHand(usedHand);
        if (this.dropContents(itemstack, player)) {
            this.playDropContentsSound((Entity)player);
            player.awardStat(Stats.ITEM_USED.get((Object)this));
            player.getCooldowns().addCooldown(itemstack.getItem(), 200);
            return InteractionResultHolder.sidedSuccess((Object)itemstack, (boolean)level.isClientSide());
        }
        return InteractionResultHolder.fail((Object)itemstack);
    }

    public boolean isBarVisible(ItemStack stack) {
        MalumPouchContentsComponent contents = this.getContents(stack);
        if (contents == null) {
            return false;
        }
        return contents.weight().compareTo(Fraction.ZERO) > 0;
    }

    public int getBarWidth(ItemStack stack) {
        MalumPouchContentsComponent contents = this.getContents(stack);
        if (contents == null) {
            return 1;
        }
        return Math.min(1 + Mth.mulAndTruncate((Fraction)contents.weight(), (int)12), 13);
    }

    public int getBarColor(ItemStack stack) {
        return BAR_COLOR;
    }

    protected final boolean dropContents(ItemStack stack, Player player) {
        MalumPouchContentsComponent contents = this.getContents(stack);
        if (contents == null) {
            return false;
        }
        return this.dropContents(stack, contents, player);
    }

    protected boolean dropContents(ItemStack stack, MalumPouchContentsComponent contents, Player player) {
        if (!contents.isEmpty()) {
            this.setContents(stack, this.emptyContents());
            if (player instanceof ServerPlayer) {
                contents.getItemsCopy().forEach(item -> player.drop(item, true));
            }
            return true;
        }
        return false;
    }

    public Optional<TooltipComponent> getTooltipImage(ItemStack stack) {
        return !stack.has(DataComponents.HIDE_TOOLTIP) && !stack.has(DataComponents.HIDE_ADDITIONAL_TOOLTIP) ? Optional.ofNullable(this.getContents(stack)) : Optional.empty();
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        MalumPouchContentsComponent contents = this.getContents(stack);
        if (contents != null) {
            int max = contents.getStorageSize();
            int i = Mth.mulAndTruncate((Fraction)contents.weight(), (int)max);
            tooltipComponents.add((Component)Component.translatable((String)"item.minecraft.bundle.fullness", (Object[])new Object[]{i, max}).withStyle(ChatFormatting.GRAY));
        }
    }

    public void onDestroyed(ItemEntity itemEntity) {
        MalumPouchContentsComponent contents = this.getContents(itemEntity.getItem());
        if (contents != null) {
            this.setContents(itemEntity.getItem(), this.emptyContents());
            ItemUtils.onContainerDestroyed((ItemEntity)itemEntity, contents.getItemsCopy());
        }
    }

    public void playRemoveOneSound(Entity entity) {
        entity.playSound(SoundEvents.BUNDLE_REMOVE_ONE, 0.8f, 0.8f + entity.level().getRandom().nextFloat() * 0.4f);
    }

    public void playInsertSound(Entity entity) {
        if (!entity.level().isClientSide) {
            SoundHelper.playSound((Entity)entity, (SoundEvent)SoundEvents.BUNDLE_INSERT, (float)0.8f, (float)(0.8f + entity.level().getRandom().nextFloat() * 0.4f));
        }
        entity.playSound(SoundEvents.BUNDLE_INSERT, 0.8f, 0.8f + entity.level().getRandom().nextFloat() * 0.4f);
    }

    public void playDropContentsSound(Entity entity) {
        entity.playSound(SoundEvents.BUNDLE_DROP_CONTENTS, 0.8f, 0.8f + entity.level().getRandom().nextFloat() * 0.4f);
    }
}

