/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.item.ether;

import com.sammy.malum.common.item.ether.EtherItem;
import java.awt.Color;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.CollisionContext;
import team.lodestar.lodestone.registry.common.particle.LodestoneScreenParticleTypes;
import team.lodestar.lodestone.systems.easing.Easing;
import team.lodestar.lodestone.systems.particle.builder.ScreenParticleBuilder;
import team.lodestar.lodestone.systems.particle.data.GenericParticleData;
import team.lodestar.lodestone.systems.particle.data.GenericParticleDataWrapper;
import team.lodestar.lodestone.systems.particle.data.color.ColorParticleData;
import team.lodestar.lodestone.systems.particle.data.color.ColorParticleDataWrapper;
import team.lodestar.lodestone.systems.particle.data.spin.SpinParticleData;
import team.lodestar.lodestone.systems.particle.data.spin.SpinParticleDataBuilder;
import team.lodestar.lodestone.systems.particle.data.spin.SpinParticleDataWrapper;
import team.lodestar.lodestone.systems.particle.screen.ScreenParticleHolder;
import team.lodestar.lodestone.systems.particle.screen.ScreenParticleType;

public class EtherTorchItem
extends EtherItem {
    protected final Block wallBlock;

    public EtherTorchItem(Block floorBlock, Block wallBlockIn, Item.Properties builder, boolean iridescent) {
        super(floorBlock, builder, iridescent);
        this.wallBlock = wallBlockIn;
    }

    @Override
    public void spawnLateParticles(ScreenParticleHolder target, Level level, float partialTick, ItemStack stack, float x, float y) {
        Color firstColor = new Color(EtherItem.getPrimaryColor(stack));
        Color secondColor = new Color(EtherItem.getSecondaryColor(stack));
        float alphaMultiplier = this.isIridescent ? 0.75f : 0.5f;
        float time = (float)level.getGameTime() + partialTick;
        SpinParticleDataBuilder spinDataBuilder = SpinParticleData.create((float)0.0f, (float)1.0f).setSpinOffset(0.025f * time % 6.28f).setEasing(Easing.EXPO_IN_OUT);
        ScreenParticleBuilder.create((ScreenParticleType)LodestoneScreenParticleTypes.STAR, (ScreenParticleHolder)target).setTransparencyData((GenericParticleDataWrapper)GenericParticleData.create((float)(0.11f * alphaMultiplier), (float)0.0f).setEasing(Easing.QUINTIC_IN).build()).setScaleData((GenericParticleDataWrapper)GenericParticleData.create((float)((float)(0.75 + Math.sin(time * 0.05f) * 0.125)), (float)0.0f).build()).setColorData((ColorParticleDataWrapper)ColorParticleData.create((Color)firstColor, (Color)secondColor).setCoefficient(1.25f).build()).setSpinData((SpinParticleDataWrapper)spinDataBuilder.build()).setLifetime(7).setRandomOffset((double)0.05f).spawnOnStack(0.0, -2.0).setScaleData((GenericParticleDataWrapper)GenericParticleData.create((float)((float)(0.75 - Math.sin(time * 0.075f) * 0.125)), (float)0.0f).build()).setColorData((ColorParticleDataWrapper)ColorParticleData.create((Color)secondColor, (Color)firstColor).build()).setSpinData((SpinParticleDataWrapper)spinDataBuilder.setSpinOffset(0.785f - 0.01f * time % 6.28f).build()).spawnOnStack(0.0, -2.0);
    }

    @Nullable
    protected BlockState getPlacementState(BlockPlaceContext context) {
        BlockState blockstate = this.wallBlock.getStateForPlacement(context);
        BlockState blockstate1 = null;
        Level level = context.getLevel();
        BlockPos blockpos = context.getClickedPos();
        for (Direction direction : context.getNearestLookingDirections()) {
            BlockState blockstate2;
            if (direction == Direction.UP) continue;
            BlockState blockState = blockstate2 = direction == Direction.DOWN ? this.getBlock().getStateForPlacement(context) : blockstate;
            if (blockstate2 == null || !blockstate2.canSurvive((LevelReader)level, blockpos)) continue;
            blockstate1 = blockstate2;
            break;
        }
        return blockstate1 != null && level.isUnobstructed(blockstate1, blockpos, CollisionContext.empty()) ? blockstate1 : null;
    }

    public void registerBlocks(Map<Block, Item> blockToItemMap, Item itemIn) {
        super.registerBlocks(blockToItemMap, itemIn);
        blockToItemMap.put(this.wallBlock, itemIn);
    }
}

