/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.spiritrite.effect.aerial;

import com.sammy.malum.common.entity.activator.BlockRiteEffectActivatorEntity;
import com.sammy.malum.core.systems.rite.effect.SpiritRiteBlockEffect;
import com.sammy.malum.core.systems.rite.effect.SpiritRiteEffectTag;
import com.sammy.malum.registry.common.MalumParticleEffectTypes;
import com.sammy.malum.registry.common.MalumSoundEvents;
import com.sammy.malum.registry.common.MalumTags;
import com.sammy.malum.registry.common.magic.MalumSpiritTypes;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FallingBlock;
import net.minecraft.world.level.block.state.BlockState;
import team.lodestar.lodestone.helpers.RandomHelper;

public class BlockGravityRiteEffect
extends SpiritRiteBlockEffect {
    private static final List<Item> TOOLS = List.of(Items.NETHERITE_PICKAXE, Items.NETHERITE_AXE, Items.NETHERITE_SHOVEL, Items.NETHERITE_HOE);

    public BlockGravityRiteEffect() {
        super(SpiritRiteEffectTag.GREATER_RITE);
    }

    @Override
    public void applyEffect(ServerLevel level, BlockRiteEffectActivatorEntity entity, BlockState state, BlockPos pos, float impact) {
        BlockState stateBelow = level.getBlockState(pos.below());
        if ((FallingBlock.isFree((BlockState)stateBelow) || !stateBelow.canOcclude() || stateBelow.is(BlockTags.SLABS)) && !state.isAir() && level.getBlockEntity(pos) == null && BlockGravityRiteEffect.canSilkTouch(level, pos, state)) {
            FallingBlockEntity.fall((Level)level, (BlockPos)pos, (BlockState)state);
            this.createEffect(level, MalumParticleEffectTypes.BLOCK_FALL_RITE_EFFECT, pos, MalumSpiritTypes.AERIAL_SPIRIT);
            level.playSound(null, pos, (SoundEvent)MalumSoundEvents.TOTEM_BLOCK_GRAVITY.get(), SoundSource.BLOCKS, 0.5f, RandomHelper.randomBetween((RandomSource)level.random, (float)1.75f, (float)2.0f));
        }
    }

    protected static boolean canSilkTouch(ServerLevel level, BlockPos pos, BlockState state) {
        if (state.is(MalumTags.BlockTags.GREATER_AERIAL_WHITELIST)) {
            return true;
        }
        ItemStack harvestToolStack = BlockGravityRiteEffect.getToolForState(state);
        if (harvestToolStack.isEmpty()) {
            return false;
        }
        harvestToolStack.enchant(level.registryAccess().holderOrThrow(Enchantments.SILK_TOUCH), 1);
        List drops = Block.getDrops((BlockState)state, (ServerLevel)level, (BlockPos)pos, null, null, (ItemStack)harvestToolStack);
        Item blockItem = state.getBlock().asItem();
        return drops.stream().anyMatch(s -> s.getItem() == blockItem);
    }

    public static ItemStack getToolForState(BlockState state) {
        if (!state.requiresCorrectToolForDrops()) {
            return new ItemStack((ItemLike)Items.NETHERITE_PICKAXE);
        }
        for (Item item : TOOLS) {
            ItemStack stack = new ItemStack((ItemLike)item);
            if (!stack.isCorrectToolForDrops(state)) continue;
            return stack;
        }
        return ItemStack.EMPTY;
    }
}

