/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.worldgen.tree;

import com.sammy.malum.common.block.nature.MalumHangingLeavesBlock;
import com.sammy.malum.common.block.nature.MalumLeavesBlock;
import com.sammy.malum.common.worldgen.WorldgenHelper;
import com.sammy.malum.common.worldgen.tree.RunewoodTreeConfiguration;
import com.sammy.malum.registry.common.block.MalumBlocks;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import team.lodestar.lodestone.helpers.block.BlockStateHelper;
import team.lodestar.lodestone.systems.worldgen.LodestoneBlockFiller;

public class RunewoodTreeFeature
extends Feature<RunewoodTreeConfiguration> {
    public static final LodestoneBlockFiller.LodestoneLayerToken LOGS = new LodestoneBlockFiller.LodestoneLayerToken();
    public static final LodestoneBlockFiller.LodestoneLayerToken LEAVES = new LodestoneBlockFiller.LodestoneLayerToken();
    public static final LodestoneBlockFiller.LodestoneLayerToken HANGING_LEAVES = new LodestoneBlockFiller.LodestoneLayerToken();

    public RunewoodTreeFeature() {
        super(RunewoodTreeConfiguration.CODEC);
    }

    private int getSapBlockCount(RandomSource random) {
        return Mth.nextInt((RandomSource)random, (int)2, (int)3);
    }

    private int getTrunkHeight(RandomSource random) {
        return Mth.nextInt((RandomSource)random, (int)7, (int)10);
    }

    private int getSideTrunkHeight(RandomSource random) {
        return Mth.nextInt((RandomSource)random, (int)0, (int)2);
    }

    private int getDownwardsBranchOffset(RandomSource random) {
        return Mth.nextInt((RandomSource)random, (int)2, (int)4);
    }

    private int getBranchLength(RandomSource random) {
        return Mth.nextInt((RandomSource)random, (int)2, (int)3);
    }

    private int getBranchHeight(RandomSource random) {
        return Mth.nextInt((RandomSource)random, (int)3, (int)5);
    }

    public boolean place(FeaturePlaceContext<RunewoodTreeConfiguration> context) {
        Direction direction;
        int i;
        WorldGenLevel level = context.level();
        BlockPos pos = context.origin();
        RunewoodTreeConfiguration config = (RunewoodTreeConfiguration)context.config();
        if (level.isEmptyBlock(pos.below()) || !config.sapling.defaultBlockState().canSurvive((LevelReader)level, pos)) {
            return false;
        }
        RandomSource rand = context.random();
        Block log = config.log;
        BlockState logState = log.defaultBlockState();
        LodestoneBlockFiller filler = new LodestoneBlockFiller().addLayers(new LodestoneBlockFiller.LodestoneLayerToken[]{LOGS, LEAVES, HANGING_LEAVES});
        int sapBlockCount = this.getSapBlockCount(rand);
        int trunkHeight = this.getTrunkHeight(rand);
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos().set((Vec3i)pos);
        for (i = 0; i <= trunkHeight; ++i) {
            if (!RunewoodTreeFeature.canPlace(level, (BlockPos)mutable)) {
                return false;
            }
            filler.getLayer(LOGS).put(mutable.immutable(), LodestoneBlockFiller.create((BlockState)logState));
            mutable.move(Direction.UP);
        }
        for (i = 0; i < 4; ++i) {
            direction = Direction.from2DDataValue((int)i);
            int sideTrunkHeight = this.getSideTrunkHeight(rand);
            if (sideTrunkHeight == 0) continue;
            mutable.set((Vec3i)pos).move(direction);
            this.addDownwardsTrunkConnections(logState, level, filler, (BlockPos)mutable);
            for (int j = 0; j < sideTrunkHeight; ++j) {
                if (!RunewoodTreeFeature.canPlace(level, (BlockPos)mutable)) {
                    return false;
                }
                filler.getLayer(LOGS).put(mutable.immutable(), LodestoneBlockFiller.create((BlockState)logState));
                mutable.move(Direction.UP);
            }
        }
        for (i = 0; i < 4; ++i) {
            int j;
            direction = Direction.from2DDataValue((int)i);
            int downwardsBranchOffset = this.getDownwardsBranchOffset(rand);
            int branchLength = this.getBranchLength(rand);
            int branchHeight = this.getBranchHeight(rand);
            mutable.set((Vec3i)pos);
            mutable.move(Direction.UP, trunkHeight - downwardsBranchOffset);
            for (j = 0; j < branchLength; ++j) {
                mutable.move(direction);
                if (!RunewoodTreeFeature.canPlace(level, (BlockPos)mutable)) {
                    return false;
                }
                filler.getLayer(LOGS).put(mutable.immutable(), LodestoneBlockFiller.create((BlockState)((BlockState)logState.setValue((Property)RotatedPillarBlock.AXIS, (Comparable)direction.getAxis()))));
            }
            for (j = 0; j < branchHeight; ++j) {
                if (!RunewoodTreeFeature.canPlace(level, (BlockPos)mutable)) {
                    return false;
                }
                filler.getLayer(LOGS).put(mutable.immutable(), LodestoneBlockFiller.create((BlockState)logState));
                mutable.move(Direction.UP);
            }
            this.makeLeafBlob(config, filler, (BlockPos)mutable.move(Direction.DOWN, branchHeight));
        }
        this.makeLeafBlob(config, filler, (BlockPos)mutable.set((Vec3i)pos).move(Direction.UP, trunkHeight - 1));
        List sapBlockPositions = WorldgenHelper.shuffle(filler.getLayer(LOGS).keySet(), rand);
        for (BlockPos blockPos : sapBlockPositions.subList(0, sapBlockCount)) {
            filler.getLayer(LOGS).replace(blockPos, e -> LodestoneBlockFiller.create((BlockState)BlockStateHelper.getBlockStateWithExistingProperties((BlockState)e.getState(), (BlockState)((Block)MalumBlocks.EXPOSED_RUNEWOOD_LOG.get()).defaultBlockState())).build());
        }
        filler.fill((LevelAccessor)level);
        WorldgenHelper.updateLeaves((LevelAccessor)level, filler.getLayer(LOGS).keySet());
        return true;
    }

    public void addDownwardsTrunkConnections(BlockState logState, WorldGenLevel level, LodestoneBlockFiller filler, BlockPos pos) {
        BlockPos.MutableBlockPos mutable = pos.mutable();
        while (true) {
            mutable.move(Direction.DOWN);
            if (!RunewoodTreeFeature.canPlace(level, (BlockPos)mutable)) break;
            filler.getLayer(LOGS).put(mutable.immutable(), LodestoneBlockFiller.create((BlockState)logState));
        }
    }

    public void makeLeafBlob(RunewoodTreeConfiguration config, LodestoneBlockFiller filler, BlockPos pos) {
        int i;
        int[] leafSizes = new int[]{1, 2, 2, 2, 1};
        int[] leafColors = new int[]{0, 1, 2, 3, 4};
        BlockPos.MutableBlockPos mutable = pos.mutable();
        BlockState leavesState = config.leaves.defaultBlockState();
        BlockState hangingLeavesState = config.hangingLeaves.defaultBlockState();
        for (i = 0; i < 5; ++i) {
            mutable.move(Direction.UP);
            LodestoneBlockFiller.BlockStateEntry leavesEntry = LodestoneBlockFiller.create((BlockState)((BlockState)leavesState.setValue((Property)MalumLeavesBlock.COLOR, (Comparable)Integer.valueOf(leafColors[i])))).build();
            this.makeLeafSlice(filler.getLayer(LEAVES), (BlockPos)mutable, leafSizes[i], leavesEntry);
        }
        mutable.set((Vec3i)pos).move(Direction.DOWN);
        for (i = 0; i < 2; ++i) {
            mutable.move(Direction.UP);
            LodestoneBlockFiller.BlockStateEntry hangingLeavesEntry = LodestoneBlockFiller.create((BlockState)((BlockState)hangingLeavesState.setValue((Property)MalumHangingLeavesBlock.COLOR, (Comparable)Integer.valueOf(leafColors[i])))).setDiscardPredicate((l, p, s) -> !filler.getLayer(LEAVES).containsKey((Object)p.above())).build();
            this.makeLeafSlice(filler.getLayer(HANGING_LEAVES), (BlockPos)mutable, leafSizes[i], hangingLeavesEntry);
        }
    }

    public void makeLeafSlice(LodestoneBlockFiller.LodestoneBlockFillerLayer layer, BlockPos pos, int leavesSize, LodestoneBlockFiller.BlockStateEntry entry) {
        this.makeLeafSlice(layer, pos, leavesSize, () -> entry);
    }

    public void makeLeafSlice(LodestoneBlockFiller.LodestoneBlockFillerLayer layer, BlockPos pos, int leavesSize, Supplier<LodestoneBlockFiller.BlockStateEntry> entry) {
        for (int x = -leavesSize; x <= leavesSize; ++x) {
            for (int z = -leavesSize; z <= leavesSize; ++z) {
                if (Math.abs(x) == leavesSize && Math.abs(z) == leavesSize) continue;
                layer.put((Object)pos.offset(x, 0, z), (Object)entry.get());
            }
        }
    }

    public static boolean canPlace(WorldGenLevel level, BlockPos pos) {
        if (level.isOutsideBuildHeight(pos)) {
            return false;
        }
        BlockState state = level.getBlockState(pos);
        if (state.is(BlockTags.REPLACEABLE_BY_TREES)) {
            return true;
        }
        return level.isEmptyBlock(pos) || state.canBeReplaced();
    }
}

