/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.compat.jei.categories;

import com.sammy.malum.MalumMod;
import com.sammy.malum.client.screen.codex.helper.CodexItemHelper;
import com.sammy.malum.common.recipe.SpiritFocusingRecipe;
import com.sammy.malum.compat.jei.JEIHandler;
import com.sammy.malum.compat.jei.JEIHelper;
import com.sammy.malum.registry.common.item.MalumItems;
import javax.annotation.Nonnull;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.common.crafting.ICustomIngredient;

public class SpiritFocusingRecipeCategory
implements IRecipeCategory<SpiritFocusingRecipe> {
    public static final ResourceLocation UID = MalumMod.malumPath("spirit_focusing");
    private final IDrawable overlay;
    private final IDrawable icon;

    public SpiritFocusingRecipeCategory(IGuiHelper guiHelper) {
        this.overlay = guiHelper.createDrawable(MalumMod.malumPath("textures/gui/spirit_focusing_jei.png"), 0, 0, 142, 185);
        this.icon = guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)MalumItems.SPIRIT_CRUCIBLE.get()));
    }

    public void draw(SpiritFocusingRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        this.overlay.draw(guiGraphics);
        if (!recipe.spirits.isEmpty()) {
            CodexItemHelper.renderItemFrames(guiGraphics, recipe.spirits.size(), 61, 12, false);
        }
    }

    public RecipeType<SpiritFocusingRecipe> getRecipeType() {
        return JEIHandler.FOCUSING;
    }

    public Component getTitle() {
        return Component.translatable((String)("malum.jei." + UID.getPath()));
    }

    public int getHeight() {
        return this.overlay.getHeight();
    }

    public int getWidth() {
        return this.overlay.getWidth();
    }

    @Nonnull
    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, SpiritFocusingRecipe recipe, IFocusGroup focuses) {
        JEIHelper.addItemsToJei(builder, RecipeIngredientRole.INPUT, 61, 12, false, recipe.spirits.stream().map(ICustomIngredient::toVanilla).toList());
        builder.addSlot(RecipeIngredientRole.INPUT, 63, 57).addIngredients(recipe.input);
        builder.addSlot(RecipeIngredientRole.OUTPUT, 63, 124).addItemStack(recipe.output);
    }
}

