/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.core.handlers;

import com.sammy.malum.MalumMod;
import com.sammy.malum.client.VoidRevelationHandler;
import com.sammy.malum.common.data.attachment.ProgressionData;
import com.sammy.malum.common.data.attachment.WeepingWellData;
import com.sammy.malum.common.entity.FloatingItemEntity;
import com.sammy.malum.common.payloads.VoidRejectionPayload;
import com.sammy.malum.core.handlers.GeasEffectHandler;
import com.sammy.malum.core.handlers.SoulHarvestHandler;
import com.sammy.malum.core.handlers.TouchOfDarknessHandler;
import com.sammy.malum.core.systems.geas.GeasEffectType;
import com.sammy.malum.registry.common.MalumAttachmentTypes;
import com.sammy.malum.registry.common.MalumDamageTypes;
import com.sammy.malum.registry.common.MalumMobEffects;
import com.sammy.malum.registry.common.MalumParticleEffectTypes;
import com.sammy.malum.registry.common.MalumSoundEvents;
import com.sammy.malum.registry.common.item.MalumItems;
import com.sammy.malum.registry.common.magic.MalumGeasEffectTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.event.tick.EntityTickEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import team.lodestar.lodestone.helpers.DamageTypeHelper;
import team.lodestar.lodestone.helpers.SoundHelper;

public class WeepingWellRejectionHandler {
    public static final ResourceLocation GRAVITY_MODIFIER_ID = MalumMod.malumPath("weeping_well_reduced_gravity");

    public static void handlePrimordialSoupContact(Entity entity) {
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            TouchOfDarknessHandler.handlePrimordialSoupContact(livingEntity);
            WeepingWellData data = (WeepingWellData)livingEntity.getData(MalumAttachmentTypes.WEEPING_WELL_INFO);
            if (data.isInRejectedState) {
                return;
            }
            data.setGoopStatus();
        }
        if (entity instanceof FloatingItemEntity) {
            return;
        }
        entity.setDeltaMovement(entity.getDeltaMovement().scale((double)0.6f));
    }

    public static void entityTick(EntityTickEvent.Pre event) {
        Entity entity = event.getEntity();
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            Level level = living.level();
            if (living.hasData(MalumAttachmentTypes.WEEPING_WELL_INFO) || living instanceof Player) {
                WeepingWellData data = (WeepingWellData)living.getData(MalumAttachmentTypes.WEEPING_WELL_INFO);
                data.update(living);
                WeepingWellRejectionHandler.updateGravity(living);
                if (data.isInGoop()) {
                    WeepingWellRejectionHandler.handleRejectionState(level, living);
                }
            }
        }
    }

    public static void updateGravity(LivingEntity entity) {
        AttributeInstance gravity = entity.getAttribute(Attributes.GRAVITY);
        if (gravity != null) {
            WeepingWellData data = (WeepingWellData)entity.getData(MalumAttachmentTypes.WEEPING_WELL_INFO);
            if (gravity.hasModifier(GRAVITY_MODIFIER_ID)) {
                gravity.removeModifier(GRAVITY_MODIFIER_ID);
            }
            if (data.isInRejectedState) {
                gravity.addTransientModifier(WeepingWellRejectionHandler.getEntityGravityAttributeModifier(entity));
            }
        }
    }

    public static void handleRejectionState(Level level, LivingEntity living) {
        WeepingWellData data = (WeepingWellData)living.getData(MalumAttachmentTypes.WEEPING_WELL_INFO);
        if (!level.isClientSide) {
            if (living instanceof Player && level.getGameTime() % 6L == 0L) {
                float volume = 0.5f + (float)data.voidRejection * 0.02f;
                float pitch = 0.5f + (float)data.voidRejection * 0.03f;
                SoundHelper.playSound((Entity)living, (SoundEvent)((SoundEvent)MalumSoundEvents.SONG_OF_THE_VOID.get()), (SoundSource)SoundSource.HOSTILE, (float)volume, (float)pitch);
            }
            if (data.wasJustRejected()) {
                if (!(living instanceof Player)) {
                    living.remove(Entity.RemovalReason.DISCARDED);
                    return;
                }
                Player player = (Player)living;
                WeepingWellRejectionHandler.launchPlayer(player);
            }
        }
        if (data.isInRejectedState && data.voidRejection > 0) {
            float intensity = (float)data.voidRejection / 60.0f;
            Vec3 movement = living.getDeltaMovement();
            living.setDeltaMovement(movement.x, Math.pow(intensity, 2.0), movement.z);
        }
    }

    public static void launchPlayer(Player player) {
        ProgressionData progression = (ProgressionData)player.getData(MalumAttachmentTypes.PROGRESSION_DATA);
        Level level = player.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            WeepingWellData.checkForWeepingWell((LivingEntity)player).ifPresent(weepingWell -> {
                BlockPos worldPosition = weepingWell.getBlockPos();
                MalumParticleEffectTypes.WEEPING_WELL_REACTS.createEffect(worldPosition.getCenter()).spawn(serverLevel);
                if (weepingWell.reachedStreakGoal) {
                    GeasEffectHandler.addGeasEffect((LivingEntity)player, (GeasEffectType)MalumGeasEffectTypes.CREED_OF_THE_BLIGHT_EATER.get());
                    weepingWell.reachedStreakGoal = false;
                }
            });
            MalumParticleEffectTypes.WEEPING_WELL_REACTS.createEffect((Entity)player).spawn(serverLevel);
            if (!player.isCreative()) {
                player.hurt(DamageTypeHelper.create((Level)level, MalumDamageTypes.VOID), 4.0f);
            }
            if (!progression.hasBeenRejected) {
                SoulHarvestHandler.spawnSpirits((Entity)player).setCustomItems((Item)MalumItems.UMBRAL_SPIRIT.get()).setPreferredCollector((LivingEntity)player).spawnSpirits(level);
            }
            PacketDistributor.sendToPlayersTrackingEntityAndSelf((Entity)player, (CustomPacketPayload)new VoidRejectionPayload(player.getId()), (CustomPacketPayload[])new CustomPacketPayload[0]);
            SoundHelper.playSound((Entity)player, (SoundEvent)((SoundEvent)MalumSoundEvents.VOID_REJECTION.get()), (float)2.0f, (float)Mth.nextFloat((RandomSource)player.getRandom(), (float)0.5f, (float)0.8f));
        } else {
            VoidRevelationHandler.seeTheRevelation(VoidRevelationHandler.RevelationType.BLACK_CRYSTAL);
        }
        progression.hasBeenRejected = true;
        player.addEffect(new MobEffectInstance(MalumMobEffects.REJECTED, 400, 0));
    }

    public static AttributeModifier getEntityGravityAttributeModifier(LivingEntity livingEntity) {
        return new AttributeModifier(GRAVITY_MODIFIER_ID, WeepingWellRejectionHandler.updateEntityGravity(livingEntity), AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL);
    }

    public static double updateEntityGravity(LivingEntity living) {
        WeepingWellData data = (WeepingWellData)living.getData(MalumAttachmentTypes.WEEPING_WELL_INFO);
        if (data.voidRejection > 0) {
            return (float)(-Math.min(60, data.voidRejection)) / 60.0f;
        }
        return 0.0;
    }
}

