/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.core.systems.rite.effect;

import com.sammy.malum.common.entity.activator.BlockRiteEffectActivatorEntity;
import com.sammy.malum.core.systems.rite.effect.SpiritRiteEffect;
import com.sammy.malum.core.systems.rite.effect.SpiritRiteEffectTag;
import com.sammy.malum.core.systems.spirit.type.SpiritArcanaType;
import com.sammy.malum.core.systems.spirit.type.SpiritLike;
import com.sammy.malum.registry.common.MalumParticleEffectTypes;
import com.sammy.malum.registry.common.MalumSoundEvents;
import com.sammy.malum.visual_effects.networked.MalumNetworkedParticleEffectColorData;
import com.sammy.malum.visual_effects.networked.MalumNetworkedParticleEffectType;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import team.lodestar.lodestone.helpers.SoundHelper;

public abstract class SpiritRiteBlockEffect
extends SpiritRiteEffect {
    protected SpiritRiteBlockEffect(SpiritRiteEffectTag ... tags) {
        this(Arrays.asList(tags));
    }

    protected SpiritRiteBlockEffect(List<SpiritRiteEffectTag> tags) {
        super(Stream.concat(Stream.of(SpiritRiteEffectTag.LOCUS_EFFECT), tags.stream()).toList());
    }

    @Override
    public boolean triggerRiteEffect(ServerLevel level, BlockPos pos, SpiritArcanaType definingSpirit, SpiritRiteEffect.RiteParameters parameters) {
        RandomSource random = level.getRandom();
        Direction direction = parameters.getTotemDirection().orElseThrow();
        BlockRiteEffectActivatorEntity entity = new BlockRiteEffectActivatorEntity((Level)level, this, pos, direction);
        entity.setSpirit(definingSpirit);
        level.addFreshEntity((Entity)entity);
        SoundHelper.playSound((Entity)entity, (SoundEvent)((SoundEvent)MalumSoundEvents.SPARK_FORMED.get()), (float)0.5f, (float)Mth.nextFloat((RandomSource)random, (float)0.9f, (float)1.1f));
        return true;
    }

    public abstract void applyEffect(ServerLevel var1, BlockRiteEffectActivatorEntity var2, BlockState var3, BlockPos var4, float var5);

    protected void createEffect(ServerLevel level, BlockPos target, SpiritLike ... spirits) {
        this.createEffect(level, target, Arrays.asList(spirits));
    }

    protected void createEffect(ServerLevel level, BlockPos target, List<? extends SpiritLike> spirits) {
        this.createEffect(level, MalumParticleEffectTypes.BLOCK_RITE_EFFECT, target, spirits);
    }

    protected void createEffect(ServerLevel level, MalumNetworkedParticleEffectType<?> effect, BlockPos target, SpiritLike ... spirits) {
        this.createEffect(level, effect, target, Arrays.asList(spirits));
    }

    protected void createEffect(ServerLevel level, MalumNetworkedParticleEffectType<?> effect, BlockPos target, List<? extends SpiritLike> spirits) {
        effect.createEffect(target).color(MalumNetworkedParticleEffectColorData.fromSpirits(spirits)).spawn(level);
    }
}

