/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.datagen.recipe.builder;

import com.sammy.malum.common.item.curiosities.curios.runes.TotemicRuneCurioItem;
import com.sammy.malum.common.item.curiosities.curios.runes.madness.MadnessRuneCurioItem;
import com.sammy.malum.common.item.curiosities.curios.runes.miracle.MiracleRuneCurioItem;
import com.sammy.malum.common.recipe.RuneworkingRecipe;
import com.sammy.malum.core.systems.spirit.type.SpiritLike;
import com.sammy.malum.registry.common.MalumSoundEvents;
import net.minecraft.core.Holder;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.common.crafting.SizedIngredient;
import team.lodestar.lodestone.recipe.builder.LodestoneRecipeBuilder;

public class RunicWorkbenchRecipeBuilder
implements LodestoneRecipeBuilder<RuneworkingRecipe> {
    private final ItemStack output;
    private final SoundEvent soundType;
    private ItemStack primaryInput;
    private SizedIngredient secondaryInput;

    public RunicWorkbenchRecipeBuilder(ItemLike output, int outputCount) {
        this(RunicWorkbenchRecipeBuilder.getRuneSound(output), output, outputCount);
    }

    public RunicWorkbenchRecipeBuilder(Holder<SoundEvent> soundType, ItemLike output, int outputCount) {
        this.soundType = (SoundEvent)soundType.value();
        this.output = new ItemStack((ItemLike)output.asItem(), outputCount);
    }

    public RunicWorkbenchRecipeBuilder setPrimaryInput(ItemStack primaryInput) {
        this.primaryInput = primaryInput;
        return this;
    }

    public RunicWorkbenchRecipeBuilder setPrimaryInput(ItemLike primaryInput, int primaryInputCount) {
        return this.setPrimaryInput(new ItemStack(primaryInput, primaryInputCount));
    }

    public RunicWorkbenchRecipeBuilder setSecondaryInput(SpiritLike type, int amount) {
        return this.setSecondaryInput(type.getSpiritShard(), amount);
    }

    public RunicWorkbenchRecipeBuilder setSecondaryInput(Item item, int amount) {
        this.secondaryInput = new SizedIngredient(Ingredient.of((ItemLike[])new ItemLike[]{item}), amount);
        return this;
    }

    public void save(RecipeOutput recipeOutput) {
        this.save(recipeOutput, (ItemLike)this.output.getItem());
    }

    public static Holder<SoundEvent> getRuneSound(ItemLike output) {
        if (output instanceof MiracleRuneCurioItem) {
            return MalumSoundEvents.RUNIC_WORKBENCH_SHAPES_RUNE_STONE;
        }
        if (output instanceof TotemicRuneCurioItem) {
            return MalumSoundEvents.RUNIC_WORKBENCH_SHAPES_RUNE_WOODEN;
        }
        if (output instanceof MadnessRuneCurioItem) {
            return MalumSoundEvents.RUNIC_WORKBENCH_SHAPES_RUNE_VOID;
        }
        throw new IllegalArgumentException("Ehehehe :33333");
    }

    public RuneworkingRecipe buildRecipe(ResourceLocation resourceLocation) {
        return new RuneworkingRecipe(SizedIngredient.of((ItemLike)this.primaryInput.getItem(), (int)this.primaryInput.getCount()), this.secondaryInput, this.output, this.soundType);
    }

    public String getRecipeSubfolder() {
        return "runeworking";
    }
}

