/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.datagen.recipe.builder;

import com.google.common.collect.Lists;
import com.sammy.malum.common.recipe.SpiritInfusionRecipe;
import com.sammy.malum.core.systems.recipe.SpiritIngredient;
import com.sammy.malum.core.systems.registry.SpiritHolder;
import com.sammy.malum.core.systems.spirit.type.SpiritArcanaType;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.common.crafting.SizedIngredient;
import team.lodestar.lodestone.recipe.builder.LodestoneRecipeBuilder;

public class SpiritInfusionRecipeBuilder
implements LodestoneRecipeBuilder<SpiritInfusionRecipe> {
    private final SizedIngredient input;
    private final ItemStack output;
    private final List<SpiritIngredient> spirits = Lists.newArrayList();
    private final List<SizedIngredient> extraIngredients = Lists.newArrayList();
    private boolean carryOverComponentData = false;

    public SpiritInfusionRecipeBuilder(Ingredient input, ItemStack output) {
        this.input = new SizedIngredient(input, 1);
        this.output = output;
    }

    public SpiritInfusionRecipeBuilder(SizedIngredient input, ItemStack output) {
        this.input = input;
        this.output = output;
    }

    public SpiritInfusionRecipeBuilder(Ingredient input, int inputCount, ItemLike output, int outputCount) {
        this(new SizedIngredient(input, inputCount), new ItemStack(output, outputCount));
    }

    public SpiritInfusionRecipeBuilder(Item input, int inputCount, ItemLike output, int outputCount) {
        this(SizedIngredient.of((ItemLike)input, (int)inputCount), new ItemStack(output, outputCount));
    }

    public SpiritInfusionRecipeBuilder(Ingredient input, ItemLike output, int outputCount) {
        this(input, new ItemStack(output, outputCount));
    }

    public SpiritInfusionRecipeBuilder(ItemLike input, ItemStack output) {
        this(Ingredient.of((ItemLike[])new ItemLike[]{input}), output);
    }

    public SpiritInfusionRecipeBuilder(ItemLike input, ItemLike output, int outputCount) {
        this(Ingredient.of((ItemLike[])new ItemLike[]{input}), new ItemStack(output, outputCount));
    }

    public SpiritInfusionRecipeBuilder addExtraItem(SizedIngredient ingredient) {
        this.extraIngredients.add(ingredient);
        return this;
    }

    public SpiritInfusionRecipeBuilder addExtraItem(Item input, int amount) {
        this.extraIngredients.add(SizedIngredient.of((ItemLike)input, (int)amount));
        return this;
    }

    public SpiritInfusionRecipeBuilder addExtraItem(TagKey<Item> input, int amount) {
        this.extraIngredients.add(SizedIngredient.of(input, (int)amount));
        return this;
    }

    public SpiritInfusionRecipeBuilder addSpirit(SpiritHolder<SpiritArcanaType> spirit, int count) {
        this.spirits.add(new SpiritIngredient((Holder<SpiritArcanaType>)spirit, count));
        return this;
    }

    public SpiritInfusionRecipeBuilder carryOverComponentData() {
        this.carryOverComponentData = true;
        return this;
    }

    public void save(RecipeOutput recipeOutput) {
        this.save(recipeOutput, (ItemLike)this.output.getItem());
    }

    public SpiritInfusionRecipe buildRecipe(ResourceLocation resourceLocation) {
        return new SpiritInfusionRecipe(this.input, this.output, this.spirits, this.extraIngredients, this.carryOverComponentData);
    }

    public String getRecipeSubfolder() {
        return "spirit_infusion";
    }
}

