/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.events;

import com.sammy.malum.common.block.storage.jar.SpiritJarBlock;
import com.sammy.malum.common.data.attachment.AvariceMarkData;
import com.sammy.malum.common.effect.ascension.AscensionEffect;
import com.sammy.malum.common.effect.ascension.LiftedEffect;
import com.sammy.malum.common.effect.gluttony.GluttonyEffect;
import com.sammy.malum.common.effect.rite.aura.StoneWardEffect;
import com.sammy.malum.common.effect.rite.aura.soulwood.OakenMightEffect;
import com.sammy.malum.common.effect.rite.aura.soulwood.SkyTetherEffect;
import com.sammy.malum.common.entity.activator.SpellweaverToolEffectActivatorEntity;
import com.sammy.malum.common.entity.nitrate.NitrateExplosion;
import com.sammy.malum.common.geas.pact.aerial.CloudSkipperGeas;
import com.sammy.malum.common.geas.pact.aerial.ContinuingShotGeas;
import com.sammy.malum.common.geas.pact.aerial.SkyBreakerGeas;
import com.sammy.malum.common.geas.pact.aerial.WindsweptGeas;
import com.sammy.malum.common.geas.pact.earthen.ProfaneAsceticGeas;
import com.sammy.malum.common.geas.pact.infernal.BlastweaverGeas;
import com.sammy.malum.common.geas.pact.sacred.LifeweaverGeas;
import com.sammy.malum.common.geas.pact.wicked.WarlockGeas;
import com.sammy.malum.common.item.cosmetic.curios.CurioTokenOfGratitude;
import com.sammy.malum.common.item.curiosities.curios.runes.madness.RuneTwinnedDurationItem;
import com.sammy.malum.common.item.curiosities.curios.runes.miracle.RuneAilmentCleansingItem;
import com.sammy.malum.common.item.curiosities.curios.sets.misc.CurioHarmonyNecklace;
import com.sammy.malum.common.item.curiosities.curios.sets.rotten.CurioVoraciousRing;
import com.sammy.malum.common.item.curiosities.curios.sets.weeping.CurioHiddenBladeNecklace;
import com.sammy.malum.common.item.curiosities.curios.sets.weeping.CurioWatcherNecklace;
import com.sammy.malum.common.item.curiosities.pouch.RavenousPouchItem;
import com.sammy.malum.common.item.curiosities.pouch.SoulwovenPouchItem;
import com.sammy.malum.common.item.curiosities.tools.spellweaver.SpellweavingPickaxeItem;
import com.sammy.malum.compat.tetra.TetraCompat;
import com.sammy.malum.core.handlers.EnsouledItemHarvestHandler;
import com.sammy.malum.core.handlers.GeasEffectHandler;
import com.sammy.malum.core.handlers.MalignantConversionHandler;
import com.sammy.malum.core.handlers.MalumAttributeEventHandler;
import com.sammy.malum.core.handlers.SoulDataHandler;
import com.sammy.malum.core.handlers.SoulHarvestHandler;
import com.sammy.malum.core.handlers.SoulWardHandler;
import com.sammy.malum.core.handlers.StaffAbilityHandler;
import com.sammy.malum.core.handlers.TouchOfDarknessHandler;
import com.sammy.malum.core.handlers.WeepingWellRejectionHandler;
import com.sammy.malum.core.handlers.WindTunnelHandler;
import com.sammy.malum.core.listeners.MalignantConversionReloadListener;
import com.sammy.malum.core.listeners.ReapingDataReloadListener;
import com.sammy.malum.core.listeners.SpellweavingEqualityReloadListener;
import com.sammy.malum.core.listeners.SpiritDataReloadListener;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.AddReloadListenerEvent;
import net.neoforged.neoforge.event.entity.EntityJoinLevelEvent;
import net.neoforged.neoforge.event.entity.item.ItemExpireEvent;
import net.neoforged.neoforge.event.entity.living.LivingChangeTargetEvent;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;
import net.neoforged.neoforge.event.entity.living.LivingDropsEvent;
import net.neoforged.neoforge.event.entity.living.LivingEntityUseItemEvent;
import net.neoforged.neoforge.event.entity.living.LivingEvent;
import net.neoforged.neoforge.event.entity.living.LivingFallEvent;
import net.neoforged.neoforge.event.entity.living.LivingHealEvent;
import net.neoforged.neoforge.event.entity.living.LivingIncomingDamageEvent;
import net.neoforged.neoforge.event.entity.living.LivingKnockBackEvent;
import net.neoforged.neoforge.event.entity.living.MobEffectEvent;
import net.neoforged.neoforge.event.entity.living.MobSpawnEvent;
import net.neoforged.neoforge.event.entity.player.ItemEntityPickupEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.neoforged.neoforge.event.level.BlockDropsEvent;
import net.neoforged.neoforge.event.level.BlockEvent;
import net.neoforged.neoforge.event.level.ExplosionEvent;
import net.neoforged.neoforge.event.level.ExplosionKnockbackEvent;
import net.neoforged.neoforge.event.tick.EntityTickEvent;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;

@EventBusSubscriber
public class RuntimeEvents {
    @SubscribeEvent
    public static void onEntityJoin(EntityJoinLevelEvent event) {
        CurioTokenOfGratitude.giveItem(event);
        SoulDataHandler.syncData(event);
        GeasEffectHandler.syncGeas(event);
        TetraCompat.entityJoin(event);
    }

    @SubscribeEvent
    public static void playerLeftClick(PlayerInteractEvent.LeftClickBlock event) {
        BlockPos pos = event.getPos();
        Level level = event.getLevel();
        BlockState state = level.getBlockState(pos);
        Block block = state.getBlock();
        if (block instanceof SpiritJarBlock) {
            SpiritJarBlock jarBlock = (SpiritJarBlock)block;
            Player player = event.getEntity();
            BlockHitResult target = Item.getPlayerPOVHitResult((Level)level, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.NONE);
            if (target.getType() == HitResult.Type.BLOCK && target.getBlockPos().equals((Object)pos) && target.getDirection().getAxis() == Direction.Axis.X && player.isCreative()) {
                event.setCanceled(jarBlock.handleAttack(level, pos, player));
            }
        }
    }

    @SubscribeEvent
    public static void onEntityJoin(MobSpawnEvent.PositionCheck event) {
        SoulDataHandler.markAsSpawnerSpawned(event);
    }

    @SubscribeEvent
    public static void onEntityFall(LivingFallEvent event) {
        AscensionEffect.onEntityFall(event);
        LiftedEffect.onEntityFall(event);
        SkyTetherEffect.onEntityFall(event);
    }

    @SubscribeEvent
    public static void onLivingTarget(LivingChangeTargetEvent event) {
        SoulDataHandler.preventTargeting(event);
    }

    @SubscribeEvent
    public static void onLivingVisibility(LivingEvent.LivingVisibilityEvent event) {
        CurioHarmonyNecklace.preventDetection(event);
        WarlockGeas.increaseDetection(event);
    }

    @SubscribeEvent
    public static void onLivingTick(EntityTickEvent.Pre event) {
        AvariceMarkData.entityTick(event);
        SoulDataHandler.entityTick(event);
        SoulWardHandler.entityTick(event);
        WindTunnelHandler.entityTick(event);
        GeasEffectHandler.entityTick(event);
        CurioWatcherNecklace.entityTick(event);
        TouchOfDarknessHandler.entityTick(event);
        CurioHiddenBladeNecklace.entityTick(event);
        MalignantConversionHandler.entityTick(event);
        WeepingWellRejectionHandler.entityTick(event);
    }

    @SubscribeEvent
    public static void onPlayerTick(PlayerTickEvent.Pre event) {
        StaffAbilityHandler.recoverStaffCharges(event);
    }

    @SubscribeEvent
    public static void modifyBlockDrops(BlockDropsEvent event) {
        AvariceMarkData.applyAvariceMark(event);
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void modifyBlockDropsLate(BlockDropsEvent event) {
        SpellweaverToolEffectActivatorEntity.redirectDrops(event);
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void breakBlock(BlockEvent.BreakEvent event) {
        SpellweavingPickaxeItem.triggerSpellweavingEffect(event);
    }

    @SubscribeEvent
    public static void registerListeners(AddReloadListenerEvent event) {
        SpellweavingEqualityReloadListener.register(event);
        SpiritDataReloadListener.register(event);
        ReapingDataReloadListener.register(event);
        MalignantConversionReloadListener.register(event);
    }

    @SubscribeEvent
    public static void isPotionApplicable(MobEffectEvent.Applicable event) {
        GluttonyEffect.canApplyPotion(event);
    }

    @SubscribeEvent
    public static void onPotionApplied(MobEffectEvent.Added event) {
        GluttonyEffect.removeExistingHunger(event);
        RuneTwinnedDurationItem.scaleDuration(event);
        RuneAilmentCleansingItem.scaleDuration(event);
    }

    @SubscribeEvent
    public static void onPotionExpired(MobEffectEvent.Expired event) {
    }

    @SubscribeEvent
    public static void onStartUsingItem(LivingEntityUseItemEvent.Start event) {
        ProfaneAsceticGeas.modifyEating(event);
        CurioVoraciousRing.modifyEating(event);
    }

    @SubscribeEvent
    public static void onPickupItem(ItemEntityPickupEvent.Pre event) {
        SoulwovenPouchItem.trySwallowItem(event);
        RavenousPouchItem.trySwallowItem(event);
    }

    @SubscribeEvent
    public static void onPickupItem(ItemEntityPickupEvent.Post event) {
        AvariceMarkData.pickupItem(event);
    }

    @SubscribeEvent
    public static void onHurt(LivingDamageEvent.Post event) {
        SoulDataHandler.exposeSoul(event);
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onIncomingDamage(LivingIncomingDamageEvent event) {
        MalignantConversionHandler.shieldPlayer(event);
    }

    @SubscribeEvent
    public static void onHurt(LivingDamageEvent.Pre event) {
        SoulWardHandler.shieldPlayer(event);
        OakenMightEffect.increaseDamage(event);
        StoneWardEffect.reduceDamage(event);
        MalumAttributeEventHandler.processAttributes(event);
    }

    @SubscribeEvent
    public static void onKnockback(LivingKnockBackEvent event) {
        WindsweptGeas.scaleKnockback(event);
        SkyBreakerGeas.scaleKnockback(event);
    }

    @SubscribeEvent
    public static void onHeal(LivingHealEvent event) {
        MalumAttributeEventHandler.heal(event);
        LifeweaverGeas.onHeal(event);
    }

    @SubscribeEvent
    public static void onDeath(LivingDeathEvent event) {
        SoulHarvestHandler.onDeath(event);
    }

    @SubscribeEvent
    public static void onDrops(LivingDropsEvent event) {
        EnsouledItemHarvestHandler.onDrops(event);
    }

    @SubscribeEvent
    public static void onItemExpire(ItemExpireEvent event) {
        EnsouledItemHarvestHandler.onItemExpire(event);
    }

    @SubscribeEvent
    public static void onItemUseStart(LivingEntityUseItemEvent.Start event) {
        ContinuingShotGeas.onItemUseStart(event);
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onExplosionDetonate(ExplosionEvent.Detonate event) {
        NitrateExplosion.processExplosion(event);
        BlastweaverGeas.processExplosion(event);
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onExplosionKnockback(ExplosionKnockbackEvent event) {
        CloudSkipperGeas.onExplosionKnockback(event);
    }
}

