/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.visual_effects.networked.altar;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.sammy.malum.common.block.curiosities.spirit_altar.SpiritAltarBlockEntity;
import com.sammy.malum.common.block.storage.IMalumSpecialItemAccessPoint;
import com.sammy.malum.visual_effects.SpiritAltarParticleEffects;
import com.sammy.malum.visual_effects.networked.MalumNetworkedParticleEffectColorData;
import com.sammy.malum.visual_effects.networked.MalumNetworkedParticleEffectType;
import io.netty.buffer.ByteBuf;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import team.lodestar.lodestone.systems.network.particle.NetworkedParticleEffectExtraData;
import team.lodestar.lodestone.systems.network.particle.NetworkedParticleEffectPositionData;

public class SpiritAltarEatItemParticleEffect
extends MalumNetworkedParticleEffectType<SpiritAltarEatItemEffectData> {
    public SpiritAltarEatItemParticleEffect(String id) {
        super(id);
    }

    public Optional<StreamCodec<ByteBuf, ? extends NetworkedParticleEffectExtraData>> getExtraCodec() {
        return Optional.of(SpiritAltarEatItemEffectData.STREAM_CODEC);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void act(Level level, RandomSource random, NetworkedParticleEffectPositionData positionData, MalumNetworkedParticleEffectColorData colorData, SpiritAltarEatItemEffectData extraData) {
        BlockEntity blockEntity = level.getBlockEntity(positionData.getAsBlockPos());
        if (!(blockEntity instanceof SpiritAltarBlockEntity)) {
            return;
        }
        SpiritAltarBlockEntity spiritAltar = (SpiritAltarBlockEntity)blockEntity;
        BlockEntity blockEntity2 = level.getBlockEntity(extraData.holderPos);
        if (!(blockEntity2 instanceof IMalumSpecialItemAccessPoint)) {
            return;
        }
        IMalumSpecialItemAccessPoint holder = (IMalumSpecialItemAccessPoint)blockEntity2;
        SpiritAltarParticleEffects.eatItemParticles(level, spiritAltar, holder, colorData, extraData.stack);
    }

    public record SpiritAltarEatItemEffectData(BlockPos holderPos, ItemStack stack) implements NetworkedParticleEffectExtraData
    {
        public static final Codec<SpiritAltarEatItemEffectData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)BlockPos.CODEC.fieldOf("holderPos").forGetter(data -> data.holderPos), (App)ItemStack.CODEC.fieldOf("stack").forGetter(data -> data.stack)).apply((Applicative)instance, SpiritAltarEatItemEffectData::new));
        public static final StreamCodec<ByteBuf, SpiritAltarEatItemEffectData> STREAM_CODEC = ByteBufCodecs.fromCodec(CODEC);
    }
}

