/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.visual_effects.networked.brazier;

import com.sammy.malum.common.block.curiosities.soul_brazier.SoulBrazierBlockEntity;
import com.sammy.malum.visual_effects.SoulBindingBrazierParticleEffects;
import com.sammy.malum.visual_effects.networked.MalumNetworkedParticleEffectColorData;
import com.sammy.malum.visual_effects.networked.MalumNetworkedParticleEffectType;
import com.sammy.malum.visual_effects.networked.brazier.SoulBrazierStateEffectData;
import io.netty.buffer.ByteBuf;
import java.util.Optional;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import team.lodestar.lodestone.systems.network.particle.NetworkedParticleEffectExtraData;
import team.lodestar.lodestone.systems.network.particle.NetworkedParticleEffectPositionData;

public class SoulBrazierEndParticleEffect
extends MalumNetworkedParticleEffectType<SoulBrazierStateEffectData> {
    public SoulBrazierEndParticleEffect(String id) {
        super(id);
    }

    public Optional<StreamCodec<ByteBuf, ? extends NetworkedParticleEffectExtraData>> getExtraCodec() {
        return Optional.of(SoulBrazierStateEffectData.STREAM_CODEC);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void act(Level level, RandomSource random, NetworkedParticleEffectPositionData positionData, MalumNetworkedParticleEffectColorData colorData, SoulBrazierStateEffectData extraData) {
        BlockEntity blockEntity = level.getBlockEntity(positionData.getAsBlockPos());
        if (!(blockEntity instanceof SoulBrazierBlockEntity)) {
            return;
        }
        SoulBrazierBlockEntity brazier = (SoulBrazierBlockEntity)blockEntity;
        brazier.state = extraData.state();
        SoulBindingBrazierParticleEffects.finishSoulBindingParticles(brazier, colorData);
    }
}

