/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.visual_effects.networked.staff;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.sammy.malum.visual_effects.networked.MalumNetworkedParticleEffectColorData;
import com.sammy.malum.visual_effects.networked.MalumNetworkedParticleEffectType;
import io.netty.buffer.ByteBuf;
import java.util.Optional;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import team.lodestar.lodestone.systems.network.particle.NetworkedParticleEffectExtraData;
import team.lodestar.lodestone.systems.network.particle.NetworkedParticleEffectPositionData;

public abstract class BoltImpactParticleEffect
extends MalumNetworkedParticleEffectType<BoltImpactEffectData> {
    public BoltImpactParticleEffect(String id) {
        super(id);
    }

    public Optional<StreamCodec<ByteBuf, ? extends NetworkedParticleEffectExtraData>> getExtraCodec() {
        return Optional.of(BoltImpactEffectData.STREAM_CODEC);
    }

    @Override
    public final void act(Level level, RandomSource random, NetworkedParticleEffectPositionData positionData, MalumNetworkedParticleEffectColorData colorData, BoltImpactEffectData extraData) {
        Vec3 projectileDirection = extraData.direction();
        float yRot = (float)(Mth.atan2((double)projectileDirection.x, (double)projectileDirection.z) * 57.2957763671875);
        float yaw = (float)Math.toRadians(yRot);
        Vec3 left = new Vec3(-Math.cos(yaw), 0.0, Math.sin(yaw));
        Vec3 up = left.cross(projectileDirection);
        this.act(level, random, positionData, colorData, projectileDirection, left, up);
    }

    public abstract void act(Level var1, RandomSource var2, NetworkedParticleEffectPositionData var3, MalumNetworkedParticleEffectColorData var4, Vec3 var5, Vec3 var6, Vec3 var7);

    public record BoltImpactEffectData(Vec3 direction) implements NetworkedParticleEffectExtraData
    {
        public static final Codec<BoltImpactEffectData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Vec3.CODEC.fieldOf("direction").forGetter(BoltImpactEffectData::direction)).apply((Applicative)instance, BoltImpactEffectData::new));
        public static final StreamCodec<ByteBuf, BoltImpactEffectData> STREAM_CODEC = ByteBufCodecs.fromCodec(CODEC);
    }
}

