/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.visual_effects.networked.wind_gust;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.sammy.malum.visual_effects.WindTunnelParticleEffects;
import com.sammy.malum.visual_effects.networked.MalumNetworkedParticleEffectColorData;
import com.sammy.malum.visual_effects.networked.MalumNetworkedParticleEffectType;
import io.netty.buffer.ByteBuf;
import java.util.Optional;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import team.lodestar.lodestone.systems.network.particle.NetworkedParticleEffectExtraData;
import team.lodestar.lodestone.systems.network.particle.NetworkedParticleEffectPositionData;

public class WindTrailParticleEffect
extends MalumNetworkedParticleEffectType<WindTrailParticleEffectData> {
    public WindTrailParticleEffect(String id) {
        super(id);
    }

    public Optional<StreamCodec<ByteBuf, ? extends NetworkedParticleEffectExtraData>> getExtraCodec() {
        return Optional.of(WindTrailParticleEffectData.STREAM_CODEC);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void act(Level level, RandomSource random, NetworkedParticleEffectPositionData positionData, MalumNetworkedParticleEffectColorData colorData, WindTrailParticleEffectData extraData) {
        Entity entity = level.getEntity(extraData.target());
        if (entity instanceof Entity) {
            Entity target = entity;
            WindTunnelParticleEffects.windTrailParticles(level, random, target, positionData.getAsVector(), colorData, extraData);
        }
    }

    public record WindTrailParticleEffectData(int target, int delay, int duration) implements NetworkedParticleEffectExtraData
    {
        public static final Codec<WindTrailParticleEffectData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("target").forGetter(WindTrailParticleEffectData::target), (App)Codec.INT.fieldOf("delay").forGetter(WindTrailParticleEffectData::delay), (App)Codec.INT.fieldOf("duration").forGetter(WindTrailParticleEffectData::duration)).apply((Applicative)instance, WindTrailParticleEffectData::new));
        public static final StreamCodec<ByteBuf, WindTrailParticleEffectData> STREAM_CODEC = ByteBufCodecs.fromCodec(CODEC);
    }
}

