/*
 * Decompiled with CFR 0.152.
 */
package com.mebeamformer.blockentity;

import appeng.api.networking.GridFlags;
import appeng.blockentity.grid.AENetworkedBlockEntity;
import com.mebeamformer.MEBeamFormer;
import com.mebeamformer.blockentity.ILinkable;
import com.mebeamformer.connection.WirelessEnergyNetwork;
import com.mebeamformer.energy.EnergyStorageHelper;
import com.mebeamformer.energy.ILongEnergyStorage;
import com.mebeamformer.integration.AE2FluxIntegration;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.energy.IEnergyStorage;

public class WirelessEnergyTowerBlockEntity
extends AENetworkedBlockEntity
implements ILinkable,
IEnergyStorage,
ILongEnergyStorage {
    private static volatile boolean FLUX_INITIALIZED = false;
    private static Class<?> FLUX_CAP_CLASS = null;
    private static Object FLUX_CAPABILITY = null;
    private static Method FLUX_EXTRACT_METHOD = null;
    private static Method FLUX_RECEIVE_METHOD = null;
    private static Method FLUX_CAN_EXTRACT_METHOD = null;
    private static Method FLUX_CAN_RECEIVE_METHOD = null;
    private static Method FLUX_GET_ENERGY_STORED_METHOD = null;
    private static Method FLUX_GET_MAX_ENERGY_STORED_METHOD = null;
    private static volatile boolean GT_INITIALIZED = false;
    private static Class<?> GT_CAP_CLASS = null;
    private static Object GT_CAPABILITY = null;
    private static Method GT_INPUTS_ENERGY_METHOD = null;
    private static Method GT_ACCEPT_ENERGY_METHOD = null;
    private static Method GT_GET_INPUT_VOLTAGE_METHOD = null;
    private static Method GT_GET_INPUT_AMPERAGE_METHOD = null;
    private static Method GT_GET_ENERGY_CAN_BE_INSERTED_METHOD = null;
    private NeighborEnergyCache energySourceCache = null;
    private static final int CACHE_VALIDITY_TICKS = 40;
    private final Set<BlockPos> links = new HashSet<BlockPos>();
    private List<BlockPos> clientLinks = Collections.emptyList();
    private final Set<BlockPos> lastSyncedLinks = new HashSet<BlockPos>();
    private static final long MAX_TRANSFER = Long.MAX_VALUE;

    public WirelessEnergyTowerBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)MEBeamFormer.WIRELESS_ENERGY_TOWER_BE.get(), pos, state);
        this.getMainNode().setFlags(new GridFlags[]{GridFlags.REQUIRE_CHANNEL}).setIdlePowerUsage(0.0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initFluxReflection() {
        if (FLUX_INITIALIZED) {
            return;
        }
        Class<WirelessEnergyTowerBlockEntity> clazz = WirelessEnergyTowerBlockEntity.class;
        synchronized (WirelessEnergyTowerBlockEntity.class) {
            if (FLUX_INITIALIZED) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return;
            }
            try {
                FLUX_CAP_CLASS = Class.forName("sonar.fluxnetworks.api.FluxCapabilities");
                Field field = FLUX_CAP_CLASS.getField("FN_ENERGY_STORAGE");
                FLUX_CAPABILITY = field.get(null);
                Class<?> storageClass = Class.forName("sonar.fluxnetworks.api.energy.IFNEnergyStorage");
                FLUX_EXTRACT_METHOD = storageClass.getMethod("extractEnergyL", Long.TYPE, Boolean.TYPE);
                FLUX_RECEIVE_METHOD = storageClass.getMethod("receiveEnergyL", Long.TYPE, Boolean.TYPE);
                FLUX_CAN_EXTRACT_METHOD = storageClass.getMethod("canExtract", new Class[0]);
                FLUX_CAN_RECEIVE_METHOD = storageClass.getMethod("canReceive", new Class[0]);
                FLUX_GET_ENERGY_STORED_METHOD = storageClass.getMethod("getEnergyStoredL", new Class[0]);
                FLUX_GET_MAX_ENERGY_STORED_METHOD = storageClass.getMethod("getMaxEnergyStoredL", new Class[0]);
            }
            catch (Exception exception) {
                // empty catch block
            }
            FLUX_INITIALIZED = true;
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initGTReflection() {
        if (GT_INITIALIZED) {
            return;
        }
        Class<WirelessEnergyTowerBlockEntity> clazz = WirelessEnergyTowerBlockEntity.class;
        synchronized (WirelessEnergyTowerBlockEntity.class) {
            if (GT_INITIALIZED) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return;
            }
            try {
                GT_CAP_CLASS = Class.forName("com.gregtechceu.gtceu.api.capability.GTCapability");
                Field field = GT_CAP_CLASS.getField("CAPABILITY_ENERGY_CONTAINER");
                GT_CAPABILITY = field.get(null);
            }
            catch (Exception exception) {
                // empty catch block
            }
            GT_INITIALIZED = true;
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    public void onLoad() {
        super.onLoad();
        if (this.level != null && !this.level.isClientSide) {
            WirelessEnergyNetwork.getInstance().registerTower(this);
        }
    }

    public void setRemoved() {
        super.setRemoved();
        if (this.level != null && !this.level.isClientSide) {
            WirelessEnergyNetwork.getInstance().unregisterTower(this);
        }
    }

    public Set<BlockPos> getLastSyncedLinks() {
        return Collections.unmodifiableSet(this.lastSyncedLinks);
    }

    public void updateSyncedLinks(Set<BlockPos> validLinks) {
        this.lastSyncedLinks.clear();
        this.lastSyncedLinks.addAll(validLinks);
        this.markForUpdate();
    }

    public void pushEnergyToTarget(BlockEntity target) {
        long inserted;
        long extracted;
        if (this.level == null || target == null) {
            return;
        }
        if (target instanceof WirelessEnergyTowerBlockEntity) {
            WirelessEnergyTowerBlockEntity targetTower = (WirelessEnergyTowerBlockEntity)target;
            this.pushEnergyToTower(targetTower);
            return;
        }
        if (AE2FluxIntegration.isAvailable() && (extracted = AE2FluxIntegration.extractEnergyFromOwnNetwork(this, Long.MAX_VALUE, true)) > 0L && (inserted = this.pushToTargetAllSides(target, extracted, true)) > 0L) {
            AE2FluxIntegration.extractEnergyFromOwnNetwork(this, inserted, false);
            this.pushToTargetAllSides(target, inserted, false);
            return;
        }
        for (Direction sourceDir : Direction.values()) {
            long actualExtracted;
            long inserted2;
            long extracted2;
            BlockPos neighborPos = this.worldPosition.relative(sourceDir);
            BlockEntity sourceBE = this.level.getBlockEntity(neighborPos);
            if (sourceBE == null || sourceBE instanceof WirelessEnergyTowerBlockEntity || (extracted2 = EnergyStorageHelper.extractEnergy(sourceBE, sourceDir.getOpposite(), Long.MAX_VALUE, true)) <= 0L || (inserted2 = this.pushToTargetAllSides(target, extracted2, true)) <= 0L || (actualExtracted = EnergyStorageHelper.extractEnergy(sourceBE, sourceDir.getOpposite(), inserted2, false)) <= 0L) continue;
            this.pushToTargetAllSides(target, actualExtracted, false);
            return;
        }
    }

    private long pushToTargetAllSides(BlockEntity target, long amount, boolean simulate) {
        for (Direction targetDir : Direction.values()) {
            long inserted = EnergyStorageHelper.insertEnergy(target, targetDir, amount, simulate);
            if (inserted <= 0L) continue;
            return inserted;
        }
        return 0L;
    }

    private void pushEnergyToTower(WirelessEnergyTowerBlockEntity targetTower) {
        long extracted;
        if (this.level == null) {
            return;
        }
        if (AE2FluxIntegration.isAvailable() && (extracted = AE2FluxIntegration.extractEnergyFromOwnNetwork(this, Long.MAX_VALUE, true)) > 0L) {
            HashSet<BlockPos> visitedSimulate = new HashSet<BlockPos>();
            visitedSimulate.add(this.worldPosition);
            long distributed = targetTower.distributeEnergyInNetwork(extracted, true, visitedSimulate);
            if (distributed > 0L) {
                HashSet<BlockPos> visitedActual = new HashSet<BlockPos>();
                visitedActual.add(this.worldPosition);
                AE2FluxIntegration.extractEnergyFromOwnNetwork(this, distributed, false);
                targetTower.distributeEnergyInNetwork(distributed, false, visitedActual);
                return;
            }
        }
        for (Direction sourceDir : Direction.values()) {
            long extracted2;
            BlockPos neighborPos = this.worldPosition.relative(sourceDir);
            BlockEntity sourceBE = this.level.getBlockEntity(neighborPos);
            if (sourceBE == null || sourceBE instanceof WirelessEnergyTowerBlockEntity || (extracted2 = EnergyStorageHelper.extractEnergy(sourceBE, sourceDir.getOpposite(), Long.MAX_VALUE, true)) <= 0L) continue;
            HashSet<BlockPos> visitedSimulate = new HashSet<BlockPos>();
            visitedSimulate.add(this.worldPosition);
            long distributed = targetTower.distributeEnergyInNetwork(extracted2, true, visitedSimulate);
            if (distributed <= 0L) continue;
            HashSet<BlockPos> visitedActual = new HashSet<BlockPos>();
            visitedActual.add(this.worldPosition);
            long actualExtracted = EnergyStorageHelper.extractEnergy(sourceBE, sourceDir.getOpposite(), distributed, false);
            targetTower.distributeEnergyInNetwork(actualExtracted, false, visitedActual);
            return;
        }
    }

    private long distributeEnergyInNetwork(long amount, boolean simulate, Set<BlockPos> visited) {
        if (this.level == null || amount <= 0L) {
            return 0L;
        }
        LinkedList<WirelessEnergyTowerBlockEntity> towerQueue = new LinkedList<WirelessEnergyTowerBlockEntity>();
        towerQueue.add(this);
        visited.add(this.worldPosition);
        long totalInserted = 0L;
        while (!towerQueue.isEmpty() && totalInserted < amount) {
            WirelessEnergyTowerBlockEntity currentTower = (WirelessEnergyTowerBlockEntity)towerQueue.poll();
            long remaining = amount - totalInserted;
            for (Direction dir : Direction.values()) {
                if (totalInserted >= amount) break;
                BlockPos neighborPos = currentTower.worldPosition.relative(dir);
                BlockEntity neighborBE = this.level.getBlockEntity(neighborPos);
                if (neighborBE == null || neighborBE instanceof WirelessEnergyTowerBlockEntity) continue;
                long neighborRemaining = amount - totalInserted;
                long inserted = this.pushToTargetAllSides(neighborBE, neighborRemaining, simulate);
                totalInserted += inserted;
            }
            if (totalInserted < amount && !currentTower.links.isEmpty()) {
                for (BlockPos targetPos : new HashSet<BlockPos>(currentTower.links)) {
                    if (totalInserted >= amount) break;
                    BlockEntity targetBE = this.level.getBlockEntity(targetPos);
                    if (targetBE == null || targetBE instanceof WirelessEnergyTowerBlockEntity) continue;
                    long targetRemaining = amount - totalInserted;
                    long inserted = this.pushToTargetAllSides(targetBE, targetRemaining, simulate);
                    totalInserted += inserted;
                }
            }
            if (totalInserted >= amount || currentTower.links.isEmpty()) continue;
            for (BlockPos targetPos : currentTower.links) {
                BlockEntity targetBE;
                if (visited.contains(targetPos) || !((targetBE = this.level.getBlockEntity(targetPos)) instanceof WirelessEnergyTowerBlockEntity)) continue;
                WirelessEnergyTowerBlockEntity targetTower = (WirelessEnergyTowerBlockEntity)targetBE;
                visited.add(targetPos);
                towerQueue.add(targetTower);
            }
        }
        return totalInserted;
    }

    private long tryExtractFromAE2Network(Object container, Direction side, long voltage, long amperage, long demand, Method acceptEnergyMethod) {
        try {
            long maxTransferEU = Math.min(voltage * amperage, demand);
            long maxTransferFE = maxTransferEU << 2;
            long extractedFE = AE2FluxIntegration.extractEnergyFromOwnNetwork(this, maxTransferFE, true);
            if (extractedFE == 0L) {
                return 0L;
            }
            long amountEU = extractedFE >> 2;
            long actualVoltage = Math.min(Math.min(voltage, amountEU), demand);
            if (actualVoltage == 0L) {
                return 0L;
            }
            long actualAmperage = Math.min(amperage, amountEU / actualVoltage);
            long acceptedAmperage = (Long)acceptEnergyMethod.invoke(container, side, actualVoltage, actualAmperage);
            long transferredEU = actualVoltage * acceptedAmperage;
            if (transferredEU > 0L) {
                long actualExtractFE = transferredEU << 2;
                AE2FluxIntegration.extractEnergyFromOwnNetwork(this, actualExtractFE, false);
                return transferredEU;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return 0L;
    }

    private boolean pushFluxToGT(Object sourceFlux, Object container, Direction side, long voltage, long amperage, long demand) {
        try {
            Method acceptEnergyMethod = container.getClass().getMethod("acceptEnergyFromNetwork", Direction.class, Long.TYPE, Long.TYPE);
            long extractedFE = (Long)FLUX_EXTRACT_METHOD.invoke(sourceFlux, Long.MAX_VALUE, true);
            if (extractedFE == 0L) {
                return false;
            }
            long amountEU = extractedFE >> 2;
            long actualVoltage = Math.min(Math.min(voltage, amountEU), demand);
            if (actualVoltage == 0L) {
                return false;
            }
            long actualAmperage = Math.min(amperage, amountEU / actualVoltage);
            long acceptedAmperage = (Long)acceptEnergyMethod.invoke(container, side, actualVoltage, actualAmperage);
            long transferredEU = actualVoltage * acceptedAmperage;
            if (transferredEU > 0L) {
                long actualExtractFE = transferredEU << 2;
                FLUX_EXTRACT_METHOD.invoke(sourceFlux, actualExtractFE, false);
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    @Override
    public void addLink(BlockPos other) {
        if (other.equals((Object)this.getBlockPos())) {
            return;
        }
        if (this.links.add(other)) {
            this.setChanged();
        }
    }

    @Override
    public void removeLink(BlockPos other) {
        if (this.links.remove(other)) {
            this.setChanged();
        }
    }

    @Override
    public Set<BlockPos> getLinks() {
        return Collections.unmodifiableSet(this.links);
    }

    public boolean hasTargets() {
        return !this.links.isEmpty();
    }

    public List<BlockPos> getClientLinks() {
        return this.clientLinks;
    }

    protected void writeToStream(RegistryFriendlyByteBuf data) {
        super.writeToStream(data);
        data.writeVarInt(this.lastSyncedLinks.size());
        for (BlockPos p : this.lastSyncedLinks) {
            data.writeBlockPos(p);
        }
    }

    protected boolean readFromStream(RegistryFriendlyByteBuf data) {
        boolean changed = super.readFromStream(data);
        int n = data.readVarInt();
        ArrayList<BlockPos> list = new ArrayList<BlockPos>(n);
        for (int i = 0; i < n; ++i) {
            list.add(data.readBlockPos());
        }
        boolean linksChanged = !list.equals(this.clientLinks);
        this.clientLinks = list;
        return changed || linksChanged;
    }

    public void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        ListTag list = new ListTag();
        for (BlockPos p : this.links) {
            CompoundTag t = new CompoundTag();
            t.putInt("x", p.getX());
            t.putInt("y", p.getY());
            t.putInt("z", p.getZ());
            list.add((Object)t);
        }
        tag.put("links", (Tag)list);
    }

    public void loadTag(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadTag(tag, registries);
        this.links.clear();
        if (tag.contains("links", 9)) {
            ListTag list = tag.getList("links", 10);
            for (int i = 0; i < list.size(); ++i) {
                CompoundTag t = list.getCompound(i);
                BlockPos pos = new BlockPos(t.getInt("x"), t.getInt("y"), t.getInt("z"));
                this.links.add(pos);
            }
        }
    }

    private boolean isFluxEnergyCapability(Object cap) {
        WirelessEnergyTowerBlockEntity.initFluxReflection();
        return FLUX_CAPABILITY != null && cap == FLUX_CAPABILITY;
    }

    private Object handleFluxMethod(String methodName, Object[] args, Direction side) {
        switch (methodName) {
            case "extractEnergyL": {
                return this.handleExtractEnergyL(args);
            }
            case "receiveEnergyL": {
                return 0L;
            }
            case "getEnergyStoredL": {
                return 0L;
            }
            case "getMaxEnergyStoredL": {
                return 0L;
            }
            case "canExtract": {
                return this.canNeighborExtract();
            }
            case "canReceive": {
                return false;
            }
        }
        return null;
    }

    private long getFluxMaxEnergyStoredL() {
        return 0L;
    }

    private long handleExtractEnergyL(Object[] args) {
        if (args == null || args.length < 2) {
            return 0L;
        }
        long maxExtract = (Long)args[0];
        boolean simulate = (Boolean)args[1];
        if (maxExtract <= 0L || this.level == null) {
            return 0L;
        }
        for (Direction dir : Direction.values()) {
            BlockPos neighborPos = this.worldPosition.relative(dir);
            BlockEntity neighborBE = this.level.getBlockEntity(neighborPos);
            if (neighborBE == null || neighborBE == this) continue;
            long extracted = this.tryExtractFluxEnergy(neighborBE, dir, maxExtract, simulate);
            if (extracted > 0L) {
                return extracted;
            }
            IEnergyStorage storage = this.getForgeEnergyStorage(neighborBE, dir.getOpposite());
            if (storage == null || !storage.canExtract()) continue;
            int maxInt = (int)Math.min(maxExtract, Integer.MAX_VALUE);
            return storage.extractEnergy(maxInt, simulate);
        }
        return 0L;
    }

    private long tryExtractFluxEnergy(BlockEntity be, Direction side, long maxExtract, boolean simulate) {
        return 0L;
    }

    private boolean canNeighborExtract() {
        if (this.level == null) {
            return false;
        }
        for (Direction dir : Direction.values()) {
            IEnergyStorage storage;
            BlockPos neighborPos = this.worldPosition.relative(dir);
            BlockEntity neighborBE = this.level.getBlockEntity(neighborPos);
            if (neighborBE == null || neighborBE == this || (storage = this.getForgeEnergyStorage(neighborBE, dir.getOpposite())) == null || !storage.canExtract()) continue;
            return true;
        }
        return false;
    }

    private IEnergyStorage getForgeEnergyStorage(BlockEntity be, Direction side) {
        if (be == null || be.getLevel() == null) {
            return null;
        }
        try {
            return (IEnergyStorage)be.getLevel().getCapability(Capabilities.EnergyStorage.BLOCK, be.getBlockPos(), be.getBlockState(), be, (Object)side);
        }
        catch (Exception e) {
            return null;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public AABB getRenderBoundingBox() {
        if (this.clientLinks == null || this.clientLinks.isEmpty()) {
            BlockPos pos = this.getBlockPos();
            return new AABB((double)(pos.getX() - 5), (double)(pos.getY() - 5), (double)(pos.getZ() - 5), (double)(pos.getX() + 6), (double)(pos.getY() + 8), (double)(pos.getZ() + 6));
        }
        BlockPos pos = this.getBlockPos();
        double minX = pos.getX();
        double minY = pos.getY();
        double minZ = pos.getZ();
        double maxX = pos.getX() + 1;
        double maxY = pos.getY() + 3;
        double maxZ = pos.getZ() + 1;
        for (BlockPos target : this.clientLinks) {
            minX = Math.min(minX, (double)target.getX());
            minY = Math.min(minY, (double)target.getY());
            minZ = Math.min(minZ, (double)target.getZ());
            maxX = Math.max(maxX, (double)(target.getX() + 1));
            maxY = Math.max(maxY, (double)(target.getY() + 1));
            maxZ = Math.max(maxZ, (double)(target.getZ() + 1));
        }
        double expansion = 5.0;
        return new AABB(minX - expansion, minY - expansion, minZ - expansion, maxX + expansion, maxY + expansion, maxZ + expansion);
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        return (int)Math.min(this.receiveEnergyL(maxReceive, simulate), Integer.MAX_VALUE);
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        return (int)Math.min(this.extractEnergyL(maxExtract, simulate), Integer.MAX_VALUE);
    }

    public int getEnergyStored() {
        return (int)Math.min(this.getEnergyStoredL(), Integer.MAX_VALUE);
    }

    public int getMaxEnergyStored() {
        return (int)Math.min(this.getMaxEnergyStoredL(), Integer.MAX_VALUE);
    }

    @Override
    public boolean canExtract() {
        if (this.level == null) {
            return false;
        }
        for (Direction dir : Direction.values()) {
            BlockPos neighborPos = this.worldPosition.relative(dir);
            BlockEntity neighborBE = this.level.getBlockEntity(neighborPos);
            if (neighborBE == null || neighborBE instanceof WirelessEnergyTowerBlockEntity || !EnergyStorageHelper.canExtract(neighborBE, dir.getOpposite())) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean canReceive() {
        return this.level != null && !this.links.isEmpty();
    }

    @Override
    public long receiveEnergyL(long maxReceive, boolean simulate) {
        if (this.level == null || maxReceive <= 0L || this.links.isEmpty()) {
            return 0L;
        }
        long totalInserted = 0L;
        block0: for (BlockPos targetPos : new ArrayList<BlockPos>(this.links)) {
            if (totalInserted >= maxReceive) break;
            BlockEntity targetBE = this.level.getBlockEntity(targetPos);
            if (targetBE == null) continue;
            long remaining = maxReceive - totalInserted;
            if (targetBE instanceof WirelessEnergyTowerBlockEntity) {
                WirelessEnergyTowerBlockEntity targetTower = (WirelessEnergyTowerBlockEntity)targetBE;
                HashSet<BlockPos> visited = new HashSet<BlockPos>();
                visited.add(this.worldPosition);
                long inserted = targetTower.receiveEnergyFromTower(remaining, simulate, visited);
                totalInserted += inserted;
                continue;
            }
            long inserted = EnergyStorageHelper.insertEnergy(targetBE, null, remaining, simulate);
            if (inserted > 0L) {
                totalInserted += inserted;
                continue;
            }
            for (Direction dir : Direction.values()) {
                inserted = EnergyStorageHelper.insertEnergy(targetBE, dir, remaining, simulate);
                if (inserted <= 0L) continue;
                totalInserted += inserted;
                continue block0;
            }
        }
        return totalInserted;
    }

    private long receiveEnergyFromTower(long amount, boolean simulate, Set<BlockPos> visited) {
        return this.distributeEnergyInNetwork(amount, simulate, visited);
    }

    @Override
    public long extractEnergyL(long maxExtract, boolean simulate) {
        if (this.level == null || maxExtract <= 0L) {
            return 0L;
        }
        for (Direction dir : Direction.values()) {
            long extracted;
            BlockPos neighborPos = this.worldPosition.relative(dir);
            BlockEntity neighborBE = this.level.getBlockEntity(neighborPos);
            if (neighborBE == null || neighborBE instanceof WirelessEnergyTowerBlockEntity || (extracted = EnergyStorageHelper.extractEnergy(neighborBE, dir.getOpposite(), maxExtract, simulate)) <= 0L) continue;
            return extracted;
        }
        return 0L;
    }

    @Override
    public long getEnergyStoredL() {
        if (this.level == null) {
            return 0L;
        }
        long total = 0L;
        for (Direction dir : Direction.values()) {
            BlockPos neighborPos = this.worldPosition.relative(dir);
            BlockEntity neighborBE = this.level.getBlockEntity(neighborPos);
            if (neighborBE == null || neighborBE instanceof WirelessEnergyTowerBlockEntity) continue;
            long stored = EnergyStorageHelper.getEnergyStored(neighborBE, dir.getOpposite());
            total += stored;
        }
        return total;
    }

    @Override
    public long getMaxEnergyStoredL() {
        return Long.MAX_VALUE;
    }

    private static class NeighborEnergyCache {
        Direction direction;
        BlockPos position;
        Object energyHandler;
        EnergySourceType type;
        long lastValidatedTick;

        private NeighborEnergyCache() {
        }
    }

    private static enum EnergySourceType {
        FLUX_NETWORKS,
        LONG_ENERGY,
        FORGE_ENERGY,
        GREGTECH,
        NONE;

    }
}

