/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.merequester.requester;

import appeng.api.stacks.AEKey;
import appeng.api.stacks.GenericStack;
import com.almostreliable.merequester.requester.abstraction.RequestHost;
import com.almostreliable.merequester.requester.status.RequestStatus;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.Mth;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.common.util.INBTSerializable;
import org.jetbrains.annotations.Nullable;

public final class Request
implements INBTSerializable<CompoundTag> {
    private static final String STATE_ID = "state";
    private static final String KEY_ID = "key";
    private static final String AMOUNT_ID = "amount";
    private static final String BATCH_ID = "batch";
    private static final String STATUS_ID = "status";
    @Nullable
    private final RequestHost host;
    private final int index;
    private boolean state = true;
    @Nullable
    private AEKey key;
    private long amount;
    private long batch = 1L;
    private RequestStatus clientStatus = RequestStatus.IDLE;

    Request(@Nullable RequestHost host, int index) {
        this.host = host;
        this.index = index;
    }

    public CompoundTag serializeNBT(HolderLookup.Provider registries) {
        CompoundTag tag = new CompoundTag();
        tag.putBoolean(STATE_ID, this.state);
        if (this.key != null) {
            tag.put(KEY_ID, (Tag)this.key.toTagGeneric(registries));
        }
        tag.putLong(AMOUNT_ID, this.amount);
        tag.putLong(BATCH_ID, this.batch);
        tag.putInt(STATUS_ID, this.clientStatus.ordinal());
        return tag;
    }

    public Component toComponent() {
        return new Component(this.state, Optional.ofNullable(this.key), this.amount, this.batch, this.clientStatus);
    }

    public void deserializeNBT(HolderLookup.Provider registries, CompoundTag tag) {
        this.state = tag.getBoolean(STATE_ID);
        this.key = tag.contains(KEY_ID) ? AEKey.fromTagGeneric((HolderLookup.Provider)registries, (CompoundTag)tag.getCompound(KEY_ID)) : null;
        this.amount = tag.getLong(AMOUNT_ID);
        this.batch = tag.getLong(BATCH_ID);
        this.clientStatus = RequestStatus.values()[tag.getInt(STATUS_ID)];
    }

    public void fromComponent(Component request) {
        this.state = request.state();
        this.key = request.key().orElse(null);
        this.amount = request.amount();
        this.batch = request.batch();
        this.clientStatus = request.clientStatus();
    }

    public void updateState(boolean state) {
        if (this.state != state) {
            this.state = state;
            if (this.host != null) {
                this.host.saveChanges();
            }
        }
    }

    public void updateAmount(long amount) {
        if (this.key == null || amount <= 0L) {
            this.resetSlot();
            return;
        }
        if (this.amount != amount) {
            this.amount = amount;
            if (this.host != null) {
                this.host.saveChanges();
            }
        }
    }

    public void updateBatch(long batch) {
        long oldBatch = this.batch;
        this.batch = Mth.clamp((long)batch, (long)1L, (long)batch);
        if (oldBatch != this.batch && this.host != null) {
            this.host.saveChanges();
        }
    }

    public String toString() {
        return String.format("Request[state=%s, key=%s, amount=%s, batch=%s, client_status=%s]", new Object[]{this.state, this.key == null ? "none" : this.key.getDisplayName(), this.amount, this.batch, this.clientStatus});
    }

    public boolean isDifferent(Request clientRequest) {
        return this.state != clientRequest.state || !Objects.equals(this.key, clientRequest.key) || this.amount != clientRequest.amount || this.batch != clientRequest.batch || this.clientStatus != clientRequest.clientStatus;
    }

    @Nullable
    GenericStack toGenericStack() {
        if (this.key == null) {
            return null;
        }
        return new GenericStack(this.key, this.amount);
    }

    void updateKey(@Nullable GenericStack stack) {
        if (stack == null) {
            if (this.key != null) {
                this.resetSlot();
            }
            return;
        }
        if (this.key != null && this.key.matches(stack)) {
            if (this.amount != stack.amount()) {
                this.updateAmount(stack.amount());
            }
            return;
        }
        this.key = stack.what();
        this.amount = stack.amount();
        this.batch = stack.what().getAmountPerUnit();
        this.keyChanged();
    }

    void setClientKey(AEKey key, long amount) {
        this.key = key;
        this.amount = amount;
    }

    private void keyChanged() {
        if (this.host != null) {
            this.host.requestChanged(this.index);
        }
    }

    private void resetSlot() {
        if (this.key == null && this.amount == 0L) {
            return;
        }
        this.key = null;
        this.amount = 0L;
        this.batch = 1L;
        this.keyChanged();
    }

    public int getIndex() {
        return this.index;
    }

    public boolean getState() {
        return this.state;
    }

    @Nullable
    public AEKey getKey() {
        return this.key;
    }

    public long getAmount() {
        return this.amount;
    }

    public long getBatch() {
        return this.batch;
    }

    @OnlyIn(value=Dist.CLIENT)
    public RequestHost getRequesterReference() {
        assert (this.host != null);
        return this.host;
    }

    public RequestStatus getClientStatus() {
        return this.clientStatus;
    }

    void setClientStatus(RequestStatus clientStatus) {
        this.clientStatus = clientStatus;
    }

    public boolean isRequesting() {
        return this.state && this.key != null;
    }

    public record Component(boolean state, Optional<AEKey> key, long amount, long batch, RequestStatus clientStatus) {
        public static final Codec<Component> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)Codec.BOOL.fieldOf(Request.STATE_ID).forGetter(Component::state), (App)Codec.optionalField((String)Request.KEY_ID, (Codec)AEKey.CODEC, (boolean)false).forGetter(Component::key), (App)Codec.LONG.fieldOf(Request.AMOUNT_ID).forGetter(Component::amount), (App)Codec.LONG.fieldOf(Request.BATCH_ID).forGetter(Component::batch), (App)RequestStatus.CODEC.fieldOf("client_status").forGetter(Component::clientStatus)).apply((Applicative)builder, Component::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, Component> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.BOOL, Component::state, (StreamCodec)ByteBufCodecs.optional((StreamCodec)AEKey.STREAM_CODEC), Component::key, (StreamCodec)ByteBufCodecs.VAR_LONG, Component::amount, (StreamCodec)ByteBufCodecs.VAR_LONG, Component::batch, RequestStatus.STREAM_CODEC, Component::clientStatus, Component::new);
    }
}

