/*
 * Decompiled with CFR 0.152.
 */
package tfar.metalbarrels.block;

import java.util.stream.IntStream;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.stats.Stats;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.monster.piglin.PiglinAi;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BarrelBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import tfar.metalbarrels.blockentity.MetalBarrelBlockEntity;
import tfar.metalbarrels.util.BarrelProperties;

public class MetalBarrelBlock
extends BarrelBlock {
    protected final BlockEntityType.BlockEntitySupplier<MetalBarrelBlockEntity<?>> tileEntitySupplier;
    private final BarrelProperties barrelProperties;

    public MetalBarrelBlock(BlockBehaviour.Properties properties, BlockEntityType.BlockEntitySupplier<MetalBarrelBlockEntity<?>> tileEntitySupplier, BarrelProperties barrelProperties) {
        super(properties);
        this.tileEntitySupplier = tileEntitySupplier;
        this.barrelProperties = barrelProperties;
    }

    public void onRemove(BlockState state, Level worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.getBlock() != newState.getBlock()) {
            BlockEntity tileentity = worldIn.getBlockEntity(pos);
            if (tileentity instanceof MetalBarrelBlockEntity) {
                MetalBarrelBlock.dropItems((MetalBarrelBlockEntity)tileentity, worldIn, pos);
                worldIn.updateNeighbourForOutputSignal(pos, (Block)this);
            }
            super.onRemove(state, worldIn, pos, newState, isMoving);
        }
    }

    public static void dropItems(MetalBarrelBlockEntity<?> barrel, Level world, BlockPos pos) {
        IntStream.range(0, barrel.barrelHandler.$getSlotCount()).mapToObj(arg_0 -> barrel.barrelHandler.$getStack(arg_0)).filter(stack -> !stack.isEmpty()).forEach(stack -> Containers.dropItemStack((Level)world, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), (ItemStack)stack));
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        if (!level.isClientSide) {
            MenuProvider tileEntity = this.getMenuProvider(state, level, pos);
            if (tileEntity != null) {
                player.openMenu(tileEntity);
                player.awardStat(Stats.OPEN_BARREL);
                PiglinAi.angerNearbyPiglins((Player)player, (boolean)true);
            }
            return InteractionResult.CONSUME;
        }
        return InteractionResult.SUCCESS;
    }

    public BarrelProperties getBarrelProperties() {
        return this.barrelProperties;
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return this.tileEntitySupplier.create(pos, state);
    }

    public boolean hasAnalogOutputSignal(BlockState state) {
        return true;
    }

    public int getAnalogOutputSignal(BlockState blockState, Level level, BlockPos pos) {
        int n;
        BlockEntity barrel = level.getBlockEntity(pos);
        if (barrel instanceof MetalBarrelBlockEntity) {
            MetalBarrelBlockEntity metalBarrelBlockEntity = (MetalBarrelBlockEntity)barrel;
            n = metalBarrelBlockEntity.calculateRedstone();
        } else {
            n = 0;
        }
        return n;
    }

    public void tick(BlockState pState, ServerLevel pLevel, BlockPos pPos, RandomSource pRandom) {
        BlockEntity blockentity = pLevel.getBlockEntity(pPos);
        if (blockentity instanceof MetalBarrelBlockEntity) {
            MetalBarrelBlockEntity metalBarrelBlockEntity = (MetalBarrelBlockEntity)blockentity;
            metalBarrelBlockEntity.recheckOpen();
        }
    }
}

