/*
 * Decompiled with CFR 0.152.
 */
package dev.su5ed.mffs.blockentity;

import dev.su5ed.mffs.api.Activatable;
import dev.su5ed.mffs.api.card.CoordLink;
import dev.su5ed.mffs.api.card.FrequencyCard;
import dev.su5ed.mffs.api.security.BiometricIdentifier;
import dev.su5ed.mffs.api.security.BiometricIdentifierLink;
import dev.su5ed.mffs.block.BaseEntityBlock;
import dev.su5ed.mffs.blockentity.BaseBlockEntity;
import dev.su5ed.mffs.blockentity.InventoryBlockEntity;
import dev.su5ed.mffs.setup.ModCapabilities;
import dev.su5ed.mffs.util.Fortron;
import dev.su5ed.mffs.util.FortronStorageImpl;
import dev.su5ed.mffs.util.FrequencyGrid;
import dev.su5ed.mffs.util.ModUtil;
import dev.su5ed.mffs.util.TransferMode;
import dev.su5ed.mffs.util.inventory.InventorySlot;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import one.util.streamex.StreamEx;

public abstract class FortronBlockEntity
extends InventoryBlockEntity
implements BiometricIdentifierLink,
Activatable {
    public final InventorySlot frequencySlot;
    public final FortronStorageImpl fortronStorage = new FortronStorageImpl(this, this.getBaseFortronTankCapacity() * 1000, () -> ((FortronBlockEntity)this).setChanged());
    private boolean markSendFortron = true;
    private boolean active;
    protected int animation;

    protected FortronBlockEntity(BlockEntityType<? extends BaseBlockEntity> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.frequencySlot = this.addSlot("frequency", InventorySlot.Mode.BOTH, ModUtil::isCard, this::onFrequencySlotChanged);
    }

    public int getAnimation() {
        return this.animation;
    }

    public void setMarkSendFortron(boolean markSendFortron) {
        this.markSendFortron = markSendFortron;
    }

    public int getBaseFortronTankCapacity() {
        return 1;
    }

    protected List<ItemStack> getCards() {
        return List.of(this.frequencySlot.getItem());
    }

    protected void animate() {
        if (this.isActive()) {
            ++this.animation;
        }
    }

    protected void onFrequencySlotChanged(ItemStack stack) {
        FrequencyCard card = (FrequencyCard)stack.getCapability(ModCapabilities.FREQUENCY_CARD);
        if (card != null) {
            card.setFrequency(this.fortronStorage.getFrequency());
        }
    }

    @Override
    public boolean isActive() {
        return this.level.isClientSide ? (Boolean)this.getBlockState().getValue(BaseEntityBlock.ACTIVE) : this.active || this.level.hasNeighborSignal(this.worldPosition);
    }

    @Override
    public void setActive(boolean active) {
        this.active = active;
        this.setChanged();
    }

    public void onLoad() {
        super.onLoad();
        FrequencyGrid.instance().register(this.fortronStorage);
    }

    public void onChunkUnloaded() {
        super.onChunkUnloaded();
        FrequencyGrid.instance().unregister(this.fortronStorage);
    }

    @Override
    public void tickServer() {
        super.tickServer();
        BlockState state = this.getBlockState();
        boolean active = this.isActive();
        if ((Boolean)state.getValue(BaseEntityBlock.ACTIVE) != active) {
            this.level.setBlockAndUpdate(this.worldPosition, (BlockState)state.setValue(BaseEntityBlock.ACTIVE, (Comparable)Boolean.valueOf(active)));
        }
    }

    @Override
    public void tickClient() {
        super.tickClient();
        this.animate();
    }

    @Override
    public void beforeBlockRemove() {
        super.beforeBlockRemove();
        if (this.markSendFortron) {
            Fortron.transferFortron(this.fortronStorage, FrequencyGrid.instance().get(this.level, (Vec3i)this.worldPosition, 100, this.fortronStorage.getFrequency()), TransferMode.DRAIN, Integer.MAX_VALUE);
        }
        this.level.invalidateCapabilities(this.worldPosition);
    }

    @Override
    protected void loadCommonTag(CompoundTag tag, HolderLookup.Provider provider) {
        super.loadCommonTag(tag, provider);
        this.fortronStorage.deserializeNBT(provider, tag.getCompound("fortronStorage"));
        this.active = tag.getBoolean("active");
    }

    @Override
    protected void saveCommonTag(CompoundTag tag, HolderLookup.Provider provider) {
        super.saveCommonTag(tag, provider);
        tag.put("fortronStorage", (Tag)this.fortronStorage.serializeNBT(provider));
        tag.putBoolean("active", this.active);
    }

    @Override
    public BiometricIdentifier getBiometricIdentifier() {
        return this.getBiometricIdentifiers().stream().findFirst().orElse(null);
    }

    @Override
    public Set<BiometricIdentifier> getBiometricIdentifiers() {
        return ((StreamEx)StreamEx.of(this.getCards()).mapPartial(stack -> {
            Item patt0$temp = stack.getItem();
            if (patt0$temp instanceof CoordLink) {
                CoordLink link = (CoordLink)patt0$temp;
                return Optional.ofNullable(link.getLink((ItemStack)stack)).map(arg_0 -> ((Level)this.level).getBlockEntity(arg_0)).map(be -> (BiometricIdentifier)be.getLevel().getCapability(ModCapabilities.BIOMETRIC_IDENTIFIER, be.getBlockPos(), be.getBlockState(), be, null));
            }
            return Optional.empty();
        }).append((Stream)StreamEx.of(FrequencyGrid.instance().get(this.fortronStorage.getFrequency())).mapPartial(storage -> {
            BlockEntity be = storage.getOwner();
            return Optional.ofNullable((BiometricIdentifier)be.getLevel().getCapability(ModCapabilities.BIOMETRIC_IDENTIFIER, be.getBlockPos(), be.getBlockState(), be, null));
        }))).toSet();
    }
}

