/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.mecrh.config;

import dev.ftb.mods.ftblibrary.snbt.config.BooleanValue;
import dev.ftb.mods.ftblibrary.snbt.config.DoubleValue;
import dev.ftb.mods.ftblibrary.snbt.config.IntValue;
import dev.ftb.mods.ftblibrary.snbt.config.SNBTConfig;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;

public interface ServerConfig {
    public static final String KEY = "mecrh-server";
    public static final SNBTConfig CONFIG = (SNBTConfig)SNBTConfig.create((String)"mecrh").comment(new String[]{"Server-specific configuration for Mighty Ender Chicken Rehatched", "Modpack defaults should be defined in <instance>/config/mecrh-server.snbt", "  (may be overwritten on modpack update)", "Server admins may locally override this by copying into <instance>/world/serverconfig/mecrh-server.snbt", "  (will NOT be overwritten on modpack update)"});
    public static final SNBTConfig GENERAL = CONFIG.addGroup("general");
    public static final BooleanValue TARGET_ALL_LIVING = (BooleanValue)GENERAL.addBoolean("target_all_living", true).comment(new String[]{"If true, Ender Chicken targets all living entities not in the `ftb:ender_chicken_friends` entity tag", "If false, Ender Chicken only targets players, and entities which attack it"});
    public static final IntValue MAX_SKILLS_AT_ONCE = (IntValue)GENERAL.addInt("max_skills_at_once", 2, 0, Integer.MAX_VALUE).comment(new String[]{"Max number of special attacks which can be used at one time"});
    public static final IntValue MAX_INCOMING_DAMAGE = (IntValue)GENERAL.addInt("max_incoming_damage", 25, 1, Integer.MAX_VALUE).comment(new String[]{"Max amount of incoming damage that the chicken can take in one hit"});
    public static final IntValue ARENA_RADIUS = (IntValue)GENERAL.addInt("arena_radius", 24, 10, Integer.MAX_VALUE).comment(new String[]{"The radius of the fight arena: the chicken is spawned in the center of this arena,", "and will stay within the arena (teleporting back to center if it somehow ends up outside)", "Chicken will despawn if no players are in the arena for 30 seconds"});
    public static final IntValue DESPAWN_TIME_NO_PLAYERS = (IntValue)GENERAL.addInt("despawn_time_no_players", 30, 0, Integer.MAX_VALUE).comment(new String[]{"Time in seconds after which the chicken will despawn if no players are within the arena", "Set to 0 to disable despawn"});
    public static final BooleanValue DROP_BROKEN_BLOCKS = (BooleanValue)GENERAL.addBoolean("drop_blocks", false).comment(new String[]{"If true, any blocks broken by the chicken will drop items as normal"});
    public static final IntValue ZOMBIE_RIDER_SPAWN_HEIGHT = (IntValue)GENERAL.addInt("zombie_rider_spawn_height", 10, 0, 50).comment(new String[]{"Height in blocks above chicken's foot position that the zombie rider initially spawns"});
    public static final SNBTConfig FORCEFIELD = CONFIG.addGroup("forcefield");
    public static final IntValue FORCEFIELD_LEVEL = (IntValue)FORCEFIELD.addInt("forcefield_level", 4, 1, Integer.MAX_VALUE).comment(new String[]{"Number of hits with an item in the `ftb:chicken_stick` item tag to break the chicken's forcefield"});
    public static final IntValue FORCEFIELD_INTERVAL = (IntValue)FORCEFIELD.addInt("forcefield_interval", 600, 100, Integer.MAX_VALUE).comment(new String[]{"Number of ticks after breaking the chicken's forcefield that it comes back up"});
    public static final BooleanValue NON_PLAYERS_IGNORE_SHIELD = (BooleanValue)FORCEFIELD.addBoolean("non_players_ignore_shield", false).comment(new String[]{"If true, non-player damage sources ignore the chicken shield", "Intended for testing; normally leave this as false."});
    public static final SNBTConfig SPIN_CONFIG = CONFIG.addGroup("spin_attack");
    public static final IntValue SPIN_ATTACK_MIN_TIME = (IntValue)SPIN_CONFIG.addInt("min_interval", 400, 20, Integer.MAX_VALUE).comment(new String[]{"Minimum interval in ticks for the spin/egg-bomb attack"});
    public static final IntValue SPIN_ATTACK_MAX_TIME = (IntValue)SPIN_CONFIG.addInt("max_interval", 600, 20, Integer.MAX_VALUE).comment(new String[]{"Maximum interval in ticks for the spin/egg-bomb attack"});
    public static final DoubleValue EGG_BOMB_SPEED_MIN = (DoubleValue)SPIN_CONFIG.addDouble("egg_bomb_speed_min", 0.05, 0.001, 5.0).comment(new String[]{"Minimum speed for launched egg bombs"});
    public static final DoubleValue EGG_BOMB_SPEED_MAX = (DoubleValue)SPIN_CONFIG.addDouble("egg_bomb_speed_max", 0.25, 0.001, 5.0).comment(new String[]{"Maximum speed for launched egg bombs"});
    public static final DoubleValue EGG_BOMB_EXPLOSION_POWER = (DoubleValue)SPIN_CONFIG.addDouble("egg_bomb_explosion_power", 2.0, 0.01, 100.0).comment(new String[]{"Egg bomb explosion power (2 = creeper, 4 = TNT"});
    public static final BooleanValue EGG_BOMB_DAMAGE_TERRAIN = (BooleanValue)SPIN_CONFIG.addBoolean("egg_bomb_damage_terrain", true).comment(new String[]{"Should egg bomb explosions damage terrain?"});
    public static final SNBTConfig CHARGE_CONFIG = CONFIG.addGroup("charge_attack");
    public static final IntValue CHARGE_MIN_INTERVAL = (IntValue)CHARGE_CONFIG.addInt("min_interval", 240, 20, Integer.MAX_VALUE).comment(new String[]{"Minimum interval in ticks for the charge attack"});
    public static final IntValue CHARGE_MAX_INTERVAL = (IntValue)CHARGE_CONFIG.addInt("max_interval", 300, 20, Integer.MAX_VALUE).comment(new String[]{"Minimum interval in ticks for the charge attack"});
    public static final IntValue CHARGE_WARMUP_TIME = (IntValue)CHARGE_CONFIG.addInt("charge_warmup_time", 12, 1, 600).comment(new String[]{"Warmup/warning time for the charge attack"});
    public static final DoubleValue MAX_CHARGE_DIST = (DoubleValue)CHARGE_CONFIG.addDouble("max_charge_dist", 16.0, 5.0, Double.MAX_VALUE).comment(new String[]{"Max distance in blocks that the chicken will charge"});
    public static final IntValue MAX_CHARGE_TIME = (IntValue)CHARGE_CONFIG.addInt("max_charge_time", 100, 20, Integer.MAX_VALUE).comment(new String[]{"Max time in ticks that the chicken will spend charging"});
    public static final DoubleValue CHARGE_SPEED = (DoubleValue)CHARGE_CONFIG.addDouble("charge_speed", 1.0, 0.1, 10.0).comment(new String[]{"Speed multiplier for the charge attack"});
    public static final DoubleValue CHARGE_DAMAGE = (DoubleValue)CHARGE_CONFIG.addDouble("charge_damage", 15.0, 0.0, Double.MAX_VALUE).comment(new String[]{"Damage the chicken will do to entities hit by the charge attack"});
    public static final SNBTConfig STAMPEDE_CONFIG = CONFIG.addGroup("stampede_attack");
    public static final IntValue STAMPEDE_MIN_INTERVAL = (IntValue)STAMPEDE_CONFIG.addInt("min_interval", 500, 20, Integer.MAX_VALUE).comment(new String[]{"Minimum interval in ticks for the stampede/zombie spawn attack"});
    public static final IntValue STAMPEDE_MAX_INTERVAL = (IntValue)STAMPEDE_CONFIG.addInt("max_interval", 500, 20, Integer.MAX_VALUE).comment(new String[]{"Maximum interval in ticks for the stampede/zombie spawn attack"});
    public static final IntValue ZOMBIE_COUNT_MIN = (IntValue)STAMPEDE_CONFIG.addInt("zombie_count_min", 6, 1, 64).comment(new String[]{"Minimum number of baby zombies spawned in the stampede"});
    public static final IntValue ZOMBIE_COUNT_MAX = (IntValue)STAMPEDE_CONFIG.addInt("zombie_count_max", 10, 1, 64).comment(new String[]{"Maximum number of baby zombies spawned in the stampede"});
    public static final SNBTConfig LASER_CONFIG = CONFIG.addGroup("laser_attack");
    public static final IntValue LASER_MIN_INTERVAL = (IntValue)LASER_CONFIG.addInt("min_interval", 180, 20, Integer.MAX_VALUE).comment(new String[]{"Minimum interval in ticks for the laser attack"});
    public static final IntValue LASER_MAX_INTERVAL = (IntValue)LASER_CONFIG.addInt("max_interval", 360, 20, Integer.MAX_VALUE).comment(new String[]{"Maximum interval in ticks for the laser attack"});
    public static final DoubleValue LASER_DAMAGE = (DoubleValue)LASER_CONFIG.addDouble("damage", 4.0, 1.0, Double.MAX_VALUE).comment(new String[]{"Damage dealt by the laser to entities it hits (ignores armor)"});
    public static final DoubleValue LASER_DAMAGE_INCREASE = (DoubleValue)LASER_CONFIG.addDouble("damage_increase", 1.25, 1.0, 10.0).comment(new String[]{"Damage increase (multiplicative) for the laser every second an entity remains in the laser beam"});
    public static final IntValue LASER_INVULN_TICKS = (IntValue)LASER_CONFIG.addInt("invulnerability_ticks", 10, 1, Integer.MAX_VALUE).comment(new String[]{"Invulnerability ticks (iframes) for entities hit by the laser"});
    public static final IntValue LASER_FIRE_TICKS = (IntValue)LASER_CONFIG.addInt("fire_ticks", 60, 0, Integer.MAX_VALUE).comment(new String[]{"Number of ticks the laser will set entities on fire for"});
    public static final SNBTConfig PECK_OF_DOOM_CONFIG = CONFIG.addGroup("peck_of_doom");
    public static final IntValue PECK_MIN_INTERVAL = (IntValue)PECK_OF_DOOM_CONFIG.addInt("min_interval", 600, 20, Integer.MAX_VALUE).comment(new String[]{"Minimum interval in ticks for the peck of doom (leap/drop) attack"});
    public static final IntValue PECK_MAX_INTERVAL = (IntValue)PECK_OF_DOOM_CONFIG.addInt("max_interval", 600, 20, Integer.MAX_VALUE).comment(new String[]{"Maximum interval in ticks for the peck of doom (leap/drop) attack"});
    public static final DoubleValue DIST_ABOVE_TARGET = (DoubleValue)PECK_OF_DOOM_CONFIG.addDouble("distance_above_target", 6.0, 1.0, Double.MAX_VALUE).comment(new String[]{"Number of blocks above target the chicken will fly to"});
    public static final IntValue MAX_PECK_CHARGE_TIME = (IntValue)PECK_OF_DOOM_CONFIG.addInt("max_charge_time", 100, 20, Integer.MAX_VALUE).comment(new String[]{"Maximum time in ticks the chicken will spend trying to reach the target"});
    public static final IntValue PECK_DROP_TIME = (IntValue)PECK_OF_DOOM_CONFIG.addInt("drop_time", 20, 5, Integer.MAX_VALUE).comment(new String[]{"Maximum time the chicken will take to drop onto the target"});
    public static final IntValue PECK_WARMUP_TIME = (IntValue)PECK_OF_DOOM_CONFIG.addInt("warmup_time", 12, 1, 600).comment(new String[]{"Warmup/warning time for the peck of doom attack"});
    public static final SNBTConfig CLUCKSTORM_CONFIG = CONFIG.addGroup("cluckstorm");
    public static final IntValue STRAY_COUNT = (IntValue)CLUCKSTORM_CONFIG.addInt("stray_count", 6, 1, 64).comment(new String[]{"Number of chicken-riding strays which are spawned in"});

    public static void onConfigChanged(boolean ignoredFromServer) {
    }

    public static int getSpinInterval(RandomSource random) {
        return ServerConfig.getInterval((Integer)SPIN_ATTACK_MIN_TIME.get(), (Integer)SPIN_ATTACK_MAX_TIME.get(), random);
    }

    public static int getChargeInterval(RandomSource random) {
        return ServerConfig.getInterval((Integer)CHARGE_MIN_INTERVAL.get(), (Integer)CHARGE_MAX_INTERVAL.get(), random);
    }

    public static float getEggSpeed(RandomSource random) {
        return ServerConfig.getInterval(((Double)EGG_BOMB_SPEED_MIN.get()).floatValue(), ((Double)EGG_BOMB_SPEED_MAX.get()).floatValue(), random);
    }

    public static int getBabyZombieCount(RandomSource random) {
        return ServerConfig.getInterval((Integer)ZOMBIE_COUNT_MIN.get(), (Integer)ZOMBIE_COUNT_MAX.get(), random);
    }

    public static int getStampedeInterval(RandomSource random) {
        return ServerConfig.getInterval((Integer)STAMPEDE_MIN_INTERVAL.get(), (Integer)STAMPEDE_MAX_INTERVAL.get(), random);
    }

    public static int getLaserInterval(RandomSource random) {
        return ServerConfig.getInterval((Integer)LASER_MIN_INTERVAL.get(), (Integer)LASER_MAX_INTERVAL.get(), random);
    }

    public static int getPeckInterval(RandomSource random) {
        return ServerConfig.getInterval((Integer)PECK_MIN_INTERVAL.get(), (Integer)PECK_MAX_INTERVAL.get(), random);
    }

    private static int getInterval(int m1, int m2, RandomSource random) {
        return m1 == m2 ? m1 : Math.min(m1, m2) + random.nextInt(Mth.abs((int)(m2 - m1)));
    }

    private static float getInterval(float m1, float m2, RandomSource random) {
        return m1 == m2 ? m1 : Math.min(m1, m2) + random.nextFloat() * Math.abs(m2 - m1);
    }

    public static int getArenaRadiusSq() {
        return (Integer)ARENA_RADIUS.get() * (Integer)ARENA_RADIUS.get();
    }
}

