/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.mecrh.entity.ai;

import dev.ftb.mods.mecrh.config.ServerConfig;
import dev.ftb.mods.mecrh.entity.EnderChicken;
import dev.ftb.mods.mecrh.entity.ai.ChickenGoal;
import dev.ftb.mods.mecrh.event.EnderChickenEvent;
import dev.ftb.mods.mecrh.registry.ModAttachments;
import dev.ftb.mods.mecrh.registry.ModSounds;
import dev.ftb.mods.mecrh.util.ChickenUtils;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3f;

public class ChickenStampedeGoal
extends ChickenGoal {
    private int stampedeCount = 0;

    public ChickenStampedeGoal(EnderChicken chicken) {
        super(chicken);
    }

    @Override
    public boolean canUse() {
        return super.canUse() && this.chicken.getHealth() <= this.chicken.getMaxHealth() * 0.7f && this.chicken.isStampedeReady();
    }

    public boolean canContinueToUse() {
        return false;
    }

    public void start() {
        ++this.stampedeCount;
        int zombieCount = ServerConfig.getBabyZombieCount(this.chicken.getRandom());
        for (int i = 0; i < zombieCount; ++i) {
            float angle = 360.0f / (float)zombieCount * (float)i * ((float)Math.PI / 180);
            float dist = 3.0f + this.chicken.getRandom().nextFloat() * 4.0f;
            Vec3 spawnPos = this.chicken.position().add((double)(Mth.cos((float)angle) * dist), 0.0, Math.sin(angle) * (double)dist);
            int y = this.chicken.level().getHeight(Heightmap.Types.WORLD_SURFACE, (int)spawnPos.x, (int)spawnPos.z);
            spawnPos = new Vec3(spawnPos.x, (double)y + 1.0, spawnPos.z);
            Zombie zombie = new Zombie(this.chicken.level());
            zombie.setBaby(true);
            zombie.setPos(spawnPos);
            zombie.setData(ModAttachments.CHICKEN_ID, (Object)this.chicken.getId());
            this.chicken.level().addFreshEntity((Entity)zombie);
            this.chicken.playSound((SoundEvent)ModSounds.CLEAR_WARN.get());
            Level level = this.chicken.level();
            if (!(level instanceof ServerLevel)) continue;
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.sendParticles((ParticleOptions)new DustParticleOptions(new Vector3f(0.8f, 0.8f, 0.2f), 1.0f), spawnPos.x, spawnPos.y, spawnPos.z, 15, 0.2, 0.2, 0.2, 0.1);
        }
        if (this.stampedeCount == 1) {
            ChickenUtils.postChickenEvent(this.chicken, EnderChickenEvent.Phase.STAMPEDE_THRESHOLD);
        }
        this.chicken.scheduleNextStampede();
    }
}

