/*
 * Decompiled with CFR 0.152.
 */
package mob_grinding_utils.network;

import mob_grinding_utils.MobGrindingUtils;
import mob_grinding_utils.network.ChickenSyncPacket;
import mob_grinding_utils.network.FlagSyncPacket;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.animal.Chicken;

public class MGUClientPackets {
    public static void HandleChickenSync(ChickenSyncPacket message) {
        Chicken chicken;
        ClientLevel world = Minecraft.getInstance().level;
        if (world == null) {
            return;
        }
        if (world.isClientSide && (chicken = (Chicken)world.getEntity(message.chickenID())) != null) {
            CompoundTag nbt = new CompoundTag();
            nbt = chicken.getPersistentData();
            nbt.putBoolean("shouldExplode", message.nbt().getBoolean("shouldExplode"));
            nbt.putInt("countDown", message.nbt().getInt("countDown"));
            if (message.nbt().getInt("countDown") >= 20) {
                for (int k = 0; k < 20; ++k) {
                    double xSpeed = world.random.nextGaussian() * 0.02;
                    double ySpeed = world.random.nextGaussian() * 0.02;
                    double zSpeed = world.random.nextGaussian() * 0.02;
                    world.addParticle((ParticleOptions)ParticleTypes.EXPLOSION, chicken.getX() + (double)(world.random.nextFloat() * chicken.getBbWidth() * 2.0f) - (double)chicken.getBbWidth(), chicken.getY() + (double)(world.random.nextFloat() * chicken.getBbHeight()), chicken.getZ() + (double)(world.random.nextFloat() * chicken.getBbWidth() * 2.0f) - (double)chicken.getBbWidth(), xSpeed, ySpeed, zSpeed);
                    world.addParticle((ParticleOptions)ParticleTypes.LAVA, chicken.getX() + (double)(world.random.nextFloat() * chicken.getBbWidth() * 2.0f) - (double)chicken.getBbWidth(), chicken.getY() + (double)(world.random.nextFloat() * chicken.getBbHeight()), chicken.getZ() + (double)(world.random.nextFloat() * chicken.getBbWidth() * 2.0f) - (double)chicken.getBbWidth(), xSpeed, ySpeed, zSpeed);
                }
            }
        }
    }

    public static void spawnGlitterParticles(double x, double y, double z, double vecX, double vecY, double vecZ) {
        ClientLevel world = Minecraft.getInstance().level;
        world.addParticle((ParticleOptions)MobGrindingUtils.PARTICLE_FLUID_XP.get(), false, x, y, z, vecX, vecY, vecZ);
    }

    public static void handleFlagSyncPacket(FlagSyncPacket packet) {
        CompoundTag nbt = Minecraft.getInstance().player.getPersistentData();
        nbt.putBoolean("MGU_WitherMuffle", packet.wither());
        nbt.putBoolean("MGU_DragonMuffle", packet.dragon());
    }
}

