/*
 * Decompiled with CFR 0.152.
 */
package com.tom.morewires.compat.cc;

import blusunrize.immersiveengineering.api.wires.Connection;
import blusunrize.immersiveengineering.api.wires.ConnectionPoint;
import blusunrize.immersiveengineering.api.wires.ConnectorBlockEntityHelper;
import blusunrize.immersiveengineering.api.wires.GlobalWireNetwork;
import blusunrize.immersiveengineering.api.wires.IImmersiveConnectable;
import blusunrize.immersiveengineering.api.wires.LocalWireNetwork;
import blusunrize.immersiveengineering.api.wires.WireType;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.metal.EnergyConnectorBlockEntity;
import com.google.common.collect.ImmutableList;
import com.tom.morewires.MoreImmersiveWires;
import com.tom.morewires.compat.cc.CCBlockEntity;
import com.tom.morewires.compat.cc.ICCTile;
import com.tom.morewires.tile.IConnector;
import dan200.computercraft.api.network.wired.WiredElement;
import dan200.computercraft.api.network.wired.WiredNode;
import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.shared.command.text.ChatHelpers;
import dan200.computercraft.shared.peripheral.modem.ModemShapes;
import dan200.computercraft.shared.peripheral.modem.ModemState;
import dan200.computercraft.shared.peripheral.modem.wired.CableBlock;
import dan200.computercraft.shared.peripheral.modem.wired.WiredModemElement;
import dan200.computercraft.shared.peripheral.modem.wired.WiredModemFullBlock;
import dan200.computercraft.shared.peripheral.modem.wired.WiredModemLocalPeripheral;
import dan200.computercraft.shared.peripheral.modem.wired.WiredModemPeripheral;
import dan200.computercraft.shared.platform.PlatformHelper;
import dan200.computercraft.shared.util.TickScheduler;
import java.util.Collection;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class CCModemConnectorBlockEntity
extends CCBlockEntity
implements IConnector,
IEBlockInterfaces.IBlockBounds,
ICCTile {
    protected GlobalWireNetwork globalNet;
    private boolean isUnloaded = false;
    private static final String NBT_PERIPHERAL_ENABLED = "PeirpheralAccess";
    private boolean peripheralAccessAllowed;
    private boolean destroyed = false;
    private boolean refreshPeripheral;
    private final WiredModemLocalPeripheral peripheral = new WiredModemLocalPeripheral(PlatformHelper.get().createPeripheralAccess((BlockEntity)this, x -> this.queueRefreshPeripheral()));
    private boolean refreshConnections = false;
    private final WiredModemElement cable = new CableElement();
    private final WiredNode node = this.cable.getNode();
    private final TickScheduler.Token tickToken = new TickScheduler.Token((BlockEntity)this);
    private final WiredModemPeripheral modem = new WiredModemPeripheral(new ModemState(() -> TickScheduler.schedule((TickScheduler.Token)this.tickToken)), this.cable, this.peripheral, this){

        public Vec3 getPosition() {
            Direction dir = CCModemConnectorBlockEntity.this.getModemDirection();
            return Vec3.atCenterOf((Vec3i)(dir == null ? CCModemConnectorBlockEntity.this.getBlockPos() : CCModemConnectorBlockEntity.this.getBlockPos().relative(dir)));
        }
    };

    public CCModemConnectorBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public BlockState getState() {
        return this.getBlockState();
    }

    public boolean canConnect() {
        return true;
    }

    public boolean canConnectCable(WireType cableType, ConnectionPoint target, Vec3i offset) {
        LocalWireNetwork local = this.globalNet.getNullableLocalNet(new ConnectionPoint(this.worldPosition, 0));
        if (local != null && !local.getConnections(this.worldPosition).isEmpty()) {
            return false;
        }
        return MoreImmersiveWires.CC_WIRE.simple().wireType == cableType;
    }

    public void connectCable(WireType cableType, ConnectionPoint target, IImmersiveConnectable other, ConnectionPoint otherTarget) {
    }

    public void setLevel(Level worldIn) {
        super.setLevel(worldIn);
        this.globalNet = GlobalWireNetwork.getNetwork((Level)worldIn);
    }

    public void removeCable(Connection connection, ConnectionPoint attachedPoint) {
        this.setChanged();
    }

    public BlockPos getPosition() {
        return this.worldPosition;
    }

    public void onChunkUnloaded() {
        super.onChunkUnloaded();
        ConnectorBlockEntityHelper.onChunkUnload((GlobalWireNetwork)this.globalNet, (IImmersiveConnectable)this);
        this.isUnloaded = true;
        this.onRemove();
    }

    public void onLoad() {
        super.onLoad();
        ConnectorBlockEntityHelper.onChunkLoad((IImmersiveConnectable)this, (Level)this.level);
        this.isUnloaded = false;
    }

    public void setRemovedIE() {
        ConnectorBlockEntityHelper.remove((Level)this.level, (IImmersiveConnectable)this);
    }

    public void setRemoved() {
        super.setRemoved();
        if (!this.isUnloaded) {
            this.setRemovedIE();
        }
        this.onRemove();
    }

    public Vec3 getConnectionOffset(ConnectionPoint here, ConnectionPoint other, WireType type) {
        Direction side = this.getFacing().getOpposite();
        double lengthFromHalf = 0.8125 - type.getRenderDiameter() / 2.0 - 0.5;
        return new Vec3(0.5 + lengthFromHalf * (double)side.getStepX(), 0.5 + lengthFromHalf * (double)side.getStepY(), 0.5 + lengthFromHalf * (double)side.getStepZ());
    }

    public VoxelShape getBlockBounds(CollisionContext ctx) {
        return Shapes.or((VoxelShape)EnergyConnectorBlockEntity.getConnectorBounds((Direction)this.getFacing(), (float)0.8125f), (VoxelShape)ModemShapes.getBounds((Direction)this.getFacing()));
    }

    @Override
    public Level getLevelNonnull() {
        return this.level;
    }

    private void onRemove() {
        this.modem.removed();
        if (this.level == null || !this.level.isClientSide) {
            this.node.remove();
        }
    }

    public void clearRemoved() {
        super.clearRemoved();
        this.refreshPeripheral = true;
        this.refreshConnections = true;
        TickScheduler.schedule((TickScheduler.Token)this.tickToken);
    }

    @Deprecated
    public void setBlockState(BlockState state) {
        Direction direction = this.getModemDirection();
        boolean hasCable = this.hasCable();
        super.setBlockState(state);
        if (this.hasCable() != hasCable || this.getModemDirection() != direction) {
            PlatformHelper.get().invalidateComponent((BlockEntity)this);
        }
    }

    private Direction getModemDirection() {
        return this.getFacing();
    }

    void neighborChanged(BlockPos neighbour) {
        Direction dir = this.getModemDirection();
        if (!this.level.isClientSide && dir != null && this.getBlockPos().relative(dir).equals((Object)neighbour) && this.isPeripheralOn()) {
            this.queueRefreshPeripheral();
        }
    }

    void queueRefreshPeripheral() {
        this.refreshPeripheral = true;
        TickScheduler.schedule((TickScheduler.Token)this.tickToken);
    }

    public InteractionResult use(Player player) {
        if (!this.canAttachPeripheral()) {
            return InteractionResult.FAIL;
        }
        if (this.getLevel().isClientSide) {
            return InteractionResult.SUCCESS;
        }
        String oldName = this.peripheral.getConnectedName();
        if (this.isPeripheralOn()) {
            this.detachPeripheral();
        } else {
            this.attachPeripheral();
        }
        String newName = this.peripheral.getConnectedName();
        if (!Objects.equals(newName, oldName)) {
            if (oldName != null) {
                player.displayClientMessage((Component)Component.translatable((String)"chat.computercraft.wired_modem.peripheral_disconnected", (Object[])new Object[]{ChatHelpers.copy((String)oldName)}), false);
            }
            if (newName != null) {
                player.displayClientMessage((Component)Component.translatable((String)"chat.computercraft.wired_modem.peripheral_connected", (Object[])new Object[]{ChatHelpers.copy((String)newName)}), false);
            }
        }
        return InteractionResult.CONSUME;
    }

    public void loadAdditional(CompoundTag nbt, HolderLookup.Provider pr) {
        super.loadAdditional(nbt, pr);
        this.peripheral.read(nbt, "");
    }

    public void saveAdditional(CompoundTag nbt, HolderLookup.Provider pr) {
        this.peripheral.write(nbt, "");
        super.saveAdditional(nbt, pr);
    }

    private void updateBlockState() {
        BlockState state = this.getBlockState();
        boolean modemOn = this.modem.getModemState().isOpen();
        boolean peripheralOn = this.peripheral.hasPeripheral();
        if ((Boolean)state.getValue((Property)WiredModemFullBlock.MODEM_ON) == modemOn && (Boolean)state.getValue((Property)WiredModemFullBlock.PERIPHERAL_ON) == peripheralOn) {
            return;
        }
        this.getLevel().setBlockAndUpdate(this.getBlockPos(), (BlockState)((BlockState)state.setValue((Property)WiredModemFullBlock.MODEM_ON, (Comparable)Boolean.valueOf(modemOn))).setValue((Property)WiredModemFullBlock.PERIPHERAL_ON, (Comparable)Boolean.valueOf(peripheralOn)));
    }

    @Override
    public void blockTick() {
        if (this.getLevel().isClientSide) {
            return;
        }
        if (this.refreshPeripheral) {
            this.refreshPeripheral = false;
            if (this.isPeripheralOn()) {
                this.attachPeripheral();
            }
        }
        if (this.modem.getModemState().pollChanged()) {
            this.updateBlockState();
        }
        this.refreshConnections = false;
    }

    void scheduleConnectionsChanged() {
        this.refreshConnections = true;
        TickScheduler.schedule((TickScheduler.Token)this.tickToken);
    }

    private void attachPeripheral() {
        Direction dir = Objects.requireNonNull(this.getModemDirection(), "Attaching without a modem");
        if (this.peripheral.attach(this.getLevel(), this.getBlockPos(), dir)) {
            this.updateConnectedPeripherals();
        }
        this.updateBlockState();
    }

    private void detachPeripheral() {
        if (this.peripheral.detach()) {
            this.updateConnectedPeripherals();
        }
        this.updateBlockState();
    }

    private void updateConnectedPeripherals() {
        this.node.updatePeripherals(this.peripheral.toMap());
    }

    public WiredElement getWiredElement(Direction direction) {
        return direction == null || CableBlock.canConnectIn((BlockState)this.getBlockState(), (Direction)direction) ? this.cable : null;
    }

    public IPeripheral getPeripheral(Direction direction) {
        return direction == null || this.getModemDirection() == direction ? this.modem : null;
    }

    private boolean isPeripheralOn() {
        return (Boolean)this.getBlockState().getValue((Property)WiredModemFullBlock.PERIPHERAL_ON);
    }

    boolean hasCable() {
        return true;
    }

    public boolean hasModem() {
        return true;
    }

    private boolean canAttachPeripheral() {
        return true;
    }

    @Override
    public WiredElement getElement() {
        return this.cable;
    }

    public Collection<ResourceLocation> getRequestedHandlers() {
        return ImmutableList.of((Object)MoreImmersiveWires.CC_WIRE.simple().NET_ID);
    }

    public IPeripheral getPeripheralCap(Direction side) {
        return side == this.getFacing() ? this.modem : null;
    }

    private class CableElement
    extends WiredModemElement {
        private CableElement() {
        }

        public Level getLevel() {
            return CCModemConnectorBlockEntity.this.getLevel();
        }

        public Vec3 getPosition() {
            return Vec3.atCenterOf((Vec3i)CCModemConnectorBlockEntity.this.getBlockPos());
        }

        protected void attachPeripheral(String name, IPeripheral peripheral) {
            CCModemConnectorBlockEntity.this.modem.attachPeripheral(name, peripheral);
        }

        protected void detachPeripheral(String name) {
            CCModemConnectorBlockEntity.this.modem.detachPeripheral(name);
        }
    }
}

