/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.morejs.features.enchantment;

import com.almostreliable.morejs.features.enchantment.EnchantmentTableEventJS;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.EnchantmentMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import net.minecraft.world.level.Level;

public class EnchantmentTableTooltipEventJS
extends EnchantmentTableEventJS {
    private final int slot;
    private final List<Component> components;
    @Nullable
    EnchantmentInstance clue;

    public EnchantmentTableTooltipEventJS(ItemStack item, ItemStack secondItem, Level level, Player player, EnchantmentMenu menu, int slot, List<Component> components) {
        super(item, secondItem, level, player, menu);
        this.slot = slot;
        this.components = components;
    }

    public List<Component> getComponents() {
        return this.components;
    }

    public void removeComponent(int index) {
        this.components.remove(index);
    }

    public void clearComponents() {
        this.components.clear();
    }

    public void addComponent(Component component) {
        this.components.add(component);
    }

    public void addComponent(int index, Component component) {
        this.components.add(index, component);
    }

    public int getSlot() {
        return this.slot;
    }

    public int getRequiredLevel() {
        return this.menu.costs[this.slot];
    }

    public EnchantmentInstance getClue() {
        if (this.clue == null) {
            int enchantmentIntId = this.menu.enchantClue[this.slot];
            int level = this.menu.levelClue[this.slot];
            Registry enchantments = this.getLevel().registryAccess().registryOrThrow(Registries.ENCHANTMENT);
            this.clue = enchantments.getHolder(enchantmentIntId).map(ref -> new EnchantmentInstance((Holder)ref, level)).orElseThrow(() -> new IllegalStateException("Enchantment not found for id: " + enchantmentIntId));
        }
        return this.clue;
    }

    public ResourceLocation getClueId() {
        return this.getClue().enchantment.unwrapKey().map(ResourceKey::location).orElse(ResourceLocation.fromNamespaceAndPath((String)"morejs", (String)"unknown_id"));
    }
}

