/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.morejs.util;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import net.minecraft.util.RandomSource;

public class WeightedList<T> {
    private static final RandomSource RANDOM = RandomSource.create();
    private final List<Entry<T>> entries;
    private final int totalWeight;

    private WeightedList(List<Entry<T>> entries) {
        Preconditions.checkNotNull(entries, (Object)"entries are null");
        Preconditions.checkArgument((!entries.isEmpty() ? 1 : 0) != 0, (Object)"entries cannot be empty");
        this.entries = entries;
        this.totalWeight = entries.stream().mapToInt(Entry::weight).sum();
    }

    public T roll() {
        return this.roll(RANDOM);
    }

    public T roll(RandomSource random) {
        int i = random.nextInt(this.totalWeight);
        for (Entry<T> e : this.entries) {
            if ((i -= e.weight) >= 0) continue;
            return e.value;
        }
        throw new IllegalStateException("Rolled past end of list");
    }

    public <T2> WeightedList<T2> map(Function<T, T2> mapper) {
        ArrayList<Entry<T>> newEntries = new ArrayList<Entry<T>>(this.entries.size());
        for (Entry<T> entry : this.entries) {
            T2 newValue = mapper.apply(entry.value);
            if (newValue == null) continue;
            newEntries.add(new Entry<T2>(entry.weight, newValue));
        }
        return new WeightedList<T>(newEntries);
    }

    private record Entry<T>(int weight, T value) {
    }

    public static class Builder<T> {
        private final List<Entry<T>> entries = new ArrayList<Entry<T>>();

        public Builder<T> add(int weight, T value) {
            this.entries.add(new Entry<T>(weight, value));
            return this;
        }

        public WeightedList<T> build() {
            return new WeightedList<T>(this.entries);
        }
    }
}

