/*
 * Decompiled with CFR 0.152.
 */
package io.github.irishgreencitrus.occultengineering.content.block.otherworld_detector;

import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import io.github.irishgreencitrus.occultengineering.content.block.otherworld_detector.OtherworldDetectorBlock;
import io.github.irishgreencitrus.occultengineering.content.block.otherworld_detector.packet.ThirdEyeActivationPacket;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;

public class OtherworldDetectorBlockEntity
extends SmartBlockEntity {
    public int turnOffInTicks = 0;
    public int comparatorSignalStrength = 0;

    public OtherworldDetectorBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState blockState) {
        super(type, pos, blockState);
        this.setLazyTickRate(20);
    }

    public void tick() {
        super.tick();
        if (this.level == null || this.level.isClientSide) {
            return;
        }
        if (this.turnOffInTicks > 0) {
            --this.turnOffInTicks;
            if (this.turnOffInTicks == 0) {
                this.deactivate();
            }
        }
        Vec3 centre = this.worldPosition.getCenter();
        Player nearestPlayer = this.level.getNearestPlayer(centre.x, centre.y, centre.z, 15.0, pl -> !pl.isSpectator());
        if (nearestPlayer == null) {
            return;
        }
        if (ThirdEyeActivationPacket.isActive(nearestPlayer)) {
            double distanceSqr = nearestPlayer.distanceToSqr(centre.x, centre.y, centre.z);
            double distance = Math.sqrt(distanceSqr);
            int newSignal = Math.max(0, 15 - (int)distance);
            this.activate(newSignal, 4);
        }
    }

    public void deactivate() {
        this.comparatorSignalStrength = 0;
        BlockState state = this.getBlockState();
        if (this.level == null) {
            return;
        }
        this.level.setBlockAndUpdate(this.worldPosition, (BlockState)state.setValue((Property)OtherworldDetectorBlock.POWERED, (Comparable)Boolean.valueOf(false)));
        this.level.updateNeighborsAt(this.worldPosition, state.getBlock());
    }

    public void activate(int signalStrength, int ticks) {
        if (this.level == null) {
            return;
        }
        BlockState state = this.getBlockState();
        this.turnOffInTicks = ticks;
        if (signalStrength != this.comparatorSignalStrength) {
            this.comparatorSignalStrength = signalStrength;
            this.level.setBlockAndUpdate(this.worldPosition, (BlockState)state.setValue((Property)OtherworldDetectorBlock.POWERED, (Comparable)Boolean.valueOf(true)));
            this.level.updateNeighborsAt(this.worldPosition, state.getBlock());
        }
    }

    public void addBehaviours(List<BlockEntityBehaviour> list) {
    }
}

