/*
 * Decompiled with CFR 0.152.
 */
package io.github.irishgreencitrus.occultengineering.content.block.phlogiport;

import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.content.logistics.box.PackageItem;
import com.simibubi.create.content.logistics.packagePort.PackagePortBlockEntity;
import com.simibubi.create.content.logistics.packagerLink.WiFiParticle;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.item.ItemHelper;
import io.github.irishgreencitrus.occultengineering.config.OccultEngineeringConfig;
import io.github.irishgreencitrus.occultengineering.content.block.phlogiport.IPhlogiportNetworkable;
import io.github.irishgreencitrus.occultengineering.content.block.phlogiport.PhlogiportLinkBehaviour;
import io.github.irishgreencitrus.occultengineering.content.block.phlogiport.PhlogiportSignalParticle;
import io.github.irishgreencitrus.occultengineering.content.block.phlogiport.PhlogiportSignalParticleData;
import io.github.irishgreencitrus.occultengineering.content.block.phlogiport.packet.PhlogiportSendEffectPacket;
import io.github.irishgreencitrus.occultengineering.registry.OccultEngineeringBlockEntities;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.createmod.catnip.platform.CatnipServices;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.BlockPositionSource;
import net.minecraft.world.level.gameevent.PositionSource;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemHandlerHelper;

public class PhlogiportBlockEntity
extends PackagePortBlockEntity {
    private PhlogiportLinkBehaviour link;
    private boolean inventoryFull = false;

    public PhlogiportBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.target = null;
    }

    private boolean shouldAcceptPackage() {
        return !this.inventoryFull;
    }

    public static void registerCapabilities(RegisterCapabilitiesEvent event) {
        event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, (BlockEntityType)OccultEngineeringBlockEntities.PHLOGIPORT.get(), (be, context) -> be.inventory);
    }

    public void filterChanged() {
        super.filterChanged();
        this.link.update(this.addressFilter, this.shouldAcceptPackage());
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        super.addBehaviours(behaviours);
        this.link = new PhlogiportLinkBehaviour((SmartBlockEntity)this);
        behaviours.add(this.link);
    }

    public void onLoad() {
        super.onLoad();
        if (this.level == null) {
            return;
        }
        if (this.level.isClientSide()) {
            return;
        }
        this.link.update(this.addressFilter, this.shouldAcceptPackage());
    }

    public void lazyTick() {
        super.lazyTick();
        if (this.level == null) {
            return;
        }
        if (this.level.isClientSide()) {
            return;
        }
        this.tryPullingFromBelow();
        this.trySendingPackage();
        this.tryPushingToBelow();
    }

    protected void trySendingPackage() {
        if (this.level == null) {
            return;
        }
        boolean inventoryFull = true;
        for (int i = 0; i < this.inventory.getSlots(); ++i) {
            BlockEntity be;
            IPhlogiportNetworkable matchingPort;
            String address;
            ItemStack stack = this.inventory.extractItem(i, 1, true);
            if (stack.isEmpty()) {
                inventoryFull = false;
                continue;
            }
            if (!PackageItem.isPackage((ItemStack)stack) || (address = PackageItem.getAddress((ItemStack)stack)).isEmpty() || Objects.equals(address, this.addressFilter) || (matchingPort = this.link.getMatchingPhlogiport(address)) == null || (be = this.level.getBlockEntity(matchingPort.getLocation())) == null || !(be instanceof PhlogiportBlockEntity)) continue;
            PhlogiportBlockEntity pbe = (PhlogiportBlockEntity)be;
            ItemStack remainder = ItemHandlerHelper.insertItemStacked((IItemHandler)pbe.inventory, (ItemStack)stack, (boolean)false);
            ServerLevel serverLevel = (ServerLevel)this.level;
            if (!remainder.isEmpty()) break;
            this.inventory.extractItem(i, 1, false);
            inventoryFull = false;
            int distance = this.worldPosition.distManhattan((Vec3i)pbe.worldPosition);
            Vec3 signalCenter = this.worldPosition.getCenter().add(PhlogiportSignalParticle.offset);
            serverLevel.sendParticles((ParticleOptions)new PhlogiportSignalParticleData((PositionSource)new BlockPositionSource(pbe.getBlockPos()), distance), signalCenter.x(), signalCenter.y(), signalCenter.z(), 1, 0.0, 0.0, 0.0, 1.0);
            CatnipServices.NETWORK.sendToClientsAround(serverLevel, (Vec3i)this.worldPosition, (double)((Integer)OccultEngineeringConfig.server().phlogiportRangeBlocks.get()).intValue(), (CustomPacketPayload)new PhlogiportSendEffectPacket(this.worldPosition, false, true));
            CatnipServices.NETWORK.sendToClientsAround(serverLevel, (Vec3i)pbe.worldPosition, (double)((Integer)OccultEngineeringConfig.server().phlogiportRangeBlocks.get()).intValue(), (CustomPacketPayload)new PhlogiportSendEffectPacket(pbe.worldPosition, true, true));
            this.level.blockEntityChanged(this.worldPosition);
            this.level.blockEntityChanged(pbe.worldPosition);
            break;
        }
        if (inventoryFull != this.inventoryFull) {
            this.inventoryFull = inventoryFull;
            this.link.update(this.addressFilter, this.shouldAcceptPackage());
        }
    }

    protected Optional<IItemHandler> getAdjacentInventory(Direction side) {
        assert (this.level != null);
        BlockEntity blockEntity = this.level.getBlockEntity(this.worldPosition.relative(side));
        if (blockEntity == null || blockEntity instanceof PhlogiportBlockEntity) {
            return Optional.empty();
        }
        return Optional.ofNullable((IItemHandler)this.level.getCapability(Capabilities.ItemHandler.BLOCK, blockEntity.getBlockPos(), (Object)side.getOpposite()));
    }

    protected void tryPullingFromBelow() {
        if (this.inventoryFull) {
            return;
        }
        Optional<IItemHandler> belowInventory = this.getAdjacentInventory(Direction.DOWN);
        if (belowInventory.isEmpty()) {
            return;
        }
        ItemStack extract = ItemHelper.extract((IItemHandler)belowInventory.get(), stack -> {
            if (!PackageItem.isPackage((ItemStack)stack)) {
                return false;
            }
            String filterString = this.getFilterString();
            return filterString == null || !PackageItem.matchAddress((ItemStack)stack, (String)filterString);
        }, (boolean)false);
        if (extract.isEmpty()) {
            return;
        }
        ItemStack leftover = ItemHandlerHelper.insertItem((IItemHandler)this.inventory, (ItemStack)extract, (boolean)true);
        if (!leftover.isEmpty()) {
            return;
        }
        ItemHandlerHelper.insertItem((IItemHandler)this.inventory, (ItemStack)extract, (boolean)false);
    }

    protected void tryPushingToBelow() {
        Optional<IItemHandler> belowInventory = this.getAdjacentInventory(Direction.DOWN);
        if (belowInventory.isEmpty()) {
            return;
        }
        ItemStack extract = ItemHelper.extract((IItemHandler)this.inventory, stack -> {
            if (!PackageItem.isPackage((ItemStack)stack)) {
                return false;
            }
            String filterString = this.getFilterString();
            return filterString == null || PackageItem.matchAddress((ItemStack)stack, (String)filterString);
        }, (boolean)false);
        if (extract.isEmpty()) {
            return;
        }
        ItemStack leftover = ItemHandlerHelper.insertItem((IItemHandler)belowInventory.get(), (ItemStack)extract, (boolean)true);
        if (!leftover.isEmpty()) {
            return;
        }
        ItemHandlerHelper.insertItem((IItemHandler)belowInventory.get(), (ItemStack)extract, (boolean)false);
    }

    protected void onOpenChange(boolean b) {
    }

    @OnlyIn(value=Dist.CLIENT)
    public void playEffect(boolean isReceiver, boolean success) {
        if (this.level == null || !this.level.isClientSide) {
            return;
        }
        ClientLevel clientLevel = (ClientLevel)this.level;
        Vec3 pos = Vec3.atCenterOf((Vec3i)this.worldPosition);
        if (isReceiver) {
            AllSoundEvents.STOCK_LINK.playAt(this.level, pos, 0.5f, 2.0f, false);
            clientLevel.addParticle((ParticleOptions)new WiFiParticle.Data(), pos.x, pos.y, pos.z, 1.0, 1.0, 1.0);
        } else {
            AllSoundEvents.STOCK_LINK.playAt((Level)clientLevel, pos, 0.5f, 2.0f, false);
            clientLevel.addParticle((ParticleOptions)new WiFiParticle.Data(), pos.x, pos.y, pos.z, 1.0, 1.0, 1.0);
        }
    }
}

