/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.api.recipe.util;

import java.util.List;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.Nullable;
import rearth.oritech.api.recipe.GrinderRecipeBuilder;
import rearth.oritech.api.recipe.OritechRecipeGenerator;
import rearth.oritech.api.recipe.PulverizerRecipeBuilder;

public class RecipeHelpers {
    public static void addDustRecipe(RecipeOutput exporter, Ingredient ingot, Item dust, String suffix) {
        RecipeHelpers.addDustRecipe(exporter, ingot, dust, null, suffix);
    }

    public static void addDustRecipe(RecipeOutput exporter, Ingredient ingot, Item dust, @Nullable Item ingotSmelted, String suffix) {
        PulverizerRecipeBuilder.build().input(ingot).result(dust).export(exporter, suffix);
        GrinderRecipeBuilder.build().input(ingot).result(dust).time(140).export(exporter, suffix);
        if (ingotSmelted != null) {
            OritechRecipeGenerator.oreSmelting(exporter, List.of(dust), RecipeCategory.MISC, (ItemLike)ingotSmelted, 1.0f, 200, "oritech");
            OritechRecipeGenerator.oreBlasting(exporter, List.of(dust), RecipeCategory.MISC, (ItemLike)ingotSmelted, 1.0f, 100, "oritech");
        }
    }

    public static RecipeBuilder createInsulatedCableRecipe(RecipeCategory category, Item output, int count, Ingredient input, Ingredient insulation) {
        return ShapedRecipeBuilder.shaped((RecipeCategory)category, (ItemLike)output, (int)count).define(Character.valueOf('c'), input).define(Character.valueOf('i'), insulation).pattern("iii").pattern("ccc").pattern("iii");
    }

    public static RecipeBuilder createRotatedCableRecipe(RecipeCategory category, Item output, int count, Ingredient input, Ingredient insulation) {
        return ShapedRecipeBuilder.shaped((RecipeCategory)category, (ItemLike)output, (int)count).define(Character.valueOf('c'), input).define(Character.valueOf('i'), insulation).pattern("ici").pattern("ici").pattern("ici");
    }

    public static Ingredient of(ItemLike item) {
        return Ingredient.of((ItemLike[])new ItemLike[]{item});
    }

    public static Ingredient of(TagKey<Item> item) {
        return Ingredient.of(item);
    }
}

