/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.block.entity.augmenter.api;

import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import rearth.oritech.block.entity.augmenter.api.Augment;

public class ModifierAugment
extends Augment {
    private final Holder<Attribute> targetAttribute;
    private final float amount;
    private final AttributeModifier.Operation operation;

    public ModifierAugment(ResourceLocation id, Holder<Attribute> targetAttribute, AttributeModifier.Operation operation, float amount, boolean toggleable) {
        super(id, toggleable);
        this.targetAttribute = targetAttribute;
        this.amount = amount;
        this.operation = operation;
    }

    @Override
    public void activate(Player player) {
        AttributeInstance instance = player.getAttribute(this.targetAttribute);
        if (instance == null) {
            return;
        }
        instance.addOrReplacePermanentModifier(new AttributeModifier(this.id, (double)this.amount, this.operation));
    }

    @Override
    public void deactivate(Player player) {
        AttributeInstance instance = player.getAttribute(this.targetAttribute);
        if (instance == null) {
            return;
        }
        instance.removeModifier(this.id);
    }

    @Override
    public void refreshServer(Player player) {
        AttributeInstance instance = player.getAttribute(this.targetAttribute);
        if (instance == null) {
            return;
        }
        instance.addOrReplacePermanentModifier(new AttributeModifier(this.id, (double)this.amount, this.operation));
    }

    @Override
    public int refreshInterval() {
        return 6000;
    }
}

