/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.block.entity.generators;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Tuple;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import rearth.oritech.Oritech;
import rearth.oritech.block.base.entity.FluidMultiblockGeneratorBlockEntity;
import rearth.oritech.client.init.ModScreens;
import rearth.oritech.init.BlockEntitiesContent;
import rearth.oritech.init.recipes.OritechRecipeType;
import rearth.oritech.init.recipes.RecipeContent;

public class LavaGeneratorEntity
extends FluidMultiblockGeneratorBlockEntity {
    public LavaGeneratorEntity(BlockPos pos, BlockState state) {
        super(BlockEntitiesContent.LAVA_GENERATOR_ENTITY, pos, state, Oritech.CONFIG.generators.lavaGeneratorData.energyPerTick());
    }

    @Override
    protected Set<Tuple<BlockPos, Direction>> getOutputTargets(BlockPos pos, Level world) {
        HashSet<Tuple<BlockPos, Direction>> res = new HashSet<Tuple<BlockPos, Direction>>();
        res.add(new Tuple((Object)pos.above(2), (Object)Direction.DOWN));
        res.add(new Tuple((Object)pos.below(), (Object)Direction.DOWN));
        res.add(new Tuple((Object)pos.east(), (Object)Direction.WEST));
        res.add(new Tuple((Object)pos.east().above(), (Object)Direction.WEST));
        res.add(new Tuple((Object)pos.south(), (Object)Direction.NORTH));
        res.add(new Tuple((Object)pos.south().above(), (Object)Direction.NORTH));
        res.add(new Tuple((Object)pos.west(), (Object)Direction.EAST));
        res.add(new Tuple((Object)pos.west().above(), (Object)Direction.EAST));
        res.add(new Tuple((Object)pos.north(), (Object)Direction.SOUTH));
        res.add(new Tuple((Object)pos.north().above(), (Object)Direction.SOUTH));
        return res;
    }

    @Override
    protected OritechRecipeType getOwnRecipeType() {
        return RecipeContent.LAVA_GENERATOR;
    }

    @Override
    public MenuType<?> getScreenHandlerType() {
        return ModScreens.LAVA_GENERATOR_SCREEN;
    }

    @Override
    public long getDefaultExtractionRate() {
        return Oritech.CONFIG.generators.lavaGeneratorData.maxEnergyExtraction();
    }

    @Override
    public long getDefaultCapacity() {
        return Oritech.CONFIG.generators.lavaGeneratorData.energyCapacity();
    }

    @Override
    public List<Vec3i> getAddonSlots() {
        return List.of(new Vec3i(1, 0, 0), new Vec3i(1, 1, 0));
    }

    @Override
    public List<Vec3i> getCorePositions() {
        return List.of(new Vec3i(0, 1, 0));
    }
}

