/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.block.entity.interaction;

import dev.architectury.fluid.FluidStack;
import dev.architectury.hooks.fluid.FluidStackHooks;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Deque;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.Vec3;
import rearth.oritech.Oritech;
import rearth.oritech.api.energy.EnergyApi;
import rearth.oritech.api.energy.containers.SimpleEnergyStorage;
import rearth.oritech.api.fluid.FluidApi;
import rearth.oritech.api.fluid.containers.SimpleFluidStorage;
import rearth.oritech.api.networking.NetworkedBlockEntity;
import rearth.oritech.api.networking.SyncField;
import rearth.oritech.api.networking.SyncType;
import rearth.oritech.block.base.entity.MachineBlockEntity;
import rearth.oritech.init.BlockContent;
import rearth.oritech.init.BlockEntitiesContent;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoBlockEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.util.GeckoLibUtil;

public class PumpBlockEntity
extends NetworkedBlockEntity
implements FluidApi.BlockProvider,
EnergyApi.BlockProvider,
GeoBlockEntity {
    private static final int MAX_SEARCH_COUNT = 100000;
    private static final int ENERGY_USAGE = 512;
    private static final int PUMP_RATE = 5;
    protected final AnimatableInstanceCache animatableInstanceCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private final AnimationController<PumpBlockEntity> animationController = this.getAnimationController();
    private final SimpleFluidStorage fluidStorage = new SimpleFluidStorage(16L * FluidStackHooks.bucketAmount(), this::setChanged);
    private final SimpleEnergyStorage energyStorage = new SimpleEnergyStorage(1000L, 0L, 20000L);
    private boolean initialized = false;
    private boolean toolheadLowered = false;
    private boolean searchActive = false;
    private BlockPos toolheadPosition;
    private FloodFillSearch searchInstance;
    private Deque<BlockPos> pendingLiquidPositions;
    @SyncField(value={SyncType.TICK})
    private long lastWorkTime;

    public PumpBlockEntity(BlockPos pos, BlockState state) {
        super(BlockEntitiesContent.PUMP_BLOCK, pos, state);
    }

    protected void saveAdditional(CompoundTag nbt, HolderLookup.Provider registryLookup) {
        super.saveAdditional(nbt, registryLookup);
        this.fluidStorage.writeNbt(nbt, "");
        nbt.putBoolean("initialized", this.initialized);
        nbt.putLong("energy", this.energyStorage.getAmount());
        if (this.pendingLiquidPositions != null) {
            nbt.putLongArray("pendingTargets", this.pendingLiquidPositions.stream().mapToLong(BlockPos::asLong).toArray());
        }
    }

    protected void loadAdditional(CompoundTag nbt, HolderLookup.Provider registryLookup) {
        super.loadAdditional(nbt, registryLookup);
        this.initialized = nbt.getBoolean("initialized");
        this.fluidStorage.readNbt(nbt, "");
        this.energyStorage.setAmount(nbt.getLong("energy"));
        this.pendingLiquidPositions = Arrays.stream(nbt.getLongArray("pendingTargets")).mapToObj(BlockPos::of).collect(Collectors.toCollection(ArrayDeque::new));
    }

    @Override
    public void serverTick(Level world, BlockPos pos, BlockState state, NetworkedBlockEntity blockEntity) {
        if (this.initialized && this.pendingLiquidPositions.isEmpty() && world.getGameTime() % 62L == 0L || !this.initialized && this.toolheadLowered && !this.searchActive && world.getGameTime() % 62L == 0L) {
            this.initialized = false;
            this.toolheadLowered = false;
            this.searchActive = false;
            this.toolheadPosition = pos;
        }
        if (!this.initialized) {
            this.progressStartup();
            return;
        }
        if (world.getGameTime() % 5L == 0L && this.hasEnoughEnergy() && world.getBestNeighborSignal(pos) <= 0) {
            if (this.pendingLiquidPositions.isEmpty() || this.tankIsFull()) {
                return;
            }
            BlockPos targetBlock = this.pendingLiquidPositions.peekLast();
            if (!world.getBlockState(targetBlock).getFluidState().isSource()) {
                this.pendingLiquidPositions.pollLast();
                return;
            }
            FluidState targetState = world.getFluidState(targetBlock);
            if (!targetState.getType().isSame((Fluid)Fluids.WATER)) {
                this.drainSourceBlock(targetBlock);
                this.pendingLiquidPositions.pollLast();
            }
            this.addLiquidToTank(targetState);
            this.useEnergy();
            this.setChanged();
            this.lastWorkTime = world.getGameTime();
            Vec3 targetPos = pos.getCenter().offsetRandom(world.random, 0.5f);
            ParticleOptions targetType = targetState.getDripParticle();
            if (targetType != null && world instanceof ServerLevel) {
                ServerLevel serverWorld = (ServerLevel)world;
                serverWorld.sendParticles(targetType, targetPos.x(), targetPos.y(), targetPos.z(), 1, 0.0, 0.0, 0.0, 1.0);
            }
        }
    }

    private boolean isBusy() {
        return this.level.getGameTime() - this.lastWorkTime < 40L;
    }

    public void onUsed(Player player) {
        MutableComponent message = Component.translatable((String)"message.oritech.pump.starting");
        if (!this.initialized) {
            message = !this.toolheadLowered ? Component.translatable((String)"message.oritech.pump.extending") : (this.searchActive ? Component.translatable((String)"message.oritech.pump.initializing") : Component.translatable((String)"message.oritech.pump.no_fluids"));
        } else if (this.isBusy()) {
            message = Component.translatable((String)"message.oritech.pump.busy");
        } else if (!this.hasEnoughEnergy()) {
            message = Component.translatable((String)"message.oritech.pump.low_energy");
        } else if (this.pendingLiquidPositions.isEmpty()) {
            message = Component.translatable((String)"message.oritech.pump.pump_finished");
        } else if (this.tankIsFull()) {
            message = Component.translatable((String)"message.oritech.pump.full");
        }
        player.displayClientMessage((Component)message, true);
    }

    private boolean hasEnoughEnergy() {
        return this.energyStorage.getAmount() >= 512L;
    }

    private void useEnergy() {
        this.energyStorage.extractIgnoringLimit(512L, false);
    }

    private boolean tankIsFull() {
        return this.fluidStorage.getAmount() > this.fluidStorage.getCapacity() - FluidStackHooks.bucketAmount();
    }

    private void addLiquidToTank(FluidState targetState) {
        this.fluidStorage.insert(FluidStack.create((Fluid)targetState.getType(), (long)FluidStackHooks.bucketAmount()), false);
    }

    private void drainSourceBlock(BlockPos targetBlock) {
        this.level.setBlockAndUpdate(targetBlock, Blocks.AIR.defaultBlockState());
    }

    private void progressStartup() {
        if (this.toolheadPosition == null) {
            this.toolheadPosition = this.worldPosition;
        }
        if (!this.toolheadLowered) {
            if (this.level.getGameTime() % 10L != 0L) {
                this.moveToolheadDown();
            }
            return;
        }
        if (this.searchActive && this.searchInstance.nextGeneration()) {
            this.finishSearch();
            this.searchActive = false;
        }
    }

    private void moveToolheadDown() {
        this.toolheadLowered = this.checkToolheadEnd(this.toolheadPosition);
        if (this.toolheadLowered) {
            this.startLiquidSearch(this.toolheadPosition.below());
            return;
        }
        this.toolheadPosition = this.toolheadPosition.below();
        this.level.setBlockAndUpdate(this.toolheadPosition, BlockContent.PUMP_TRUNK_BLOCK.defaultBlockState());
    }

    private boolean checkToolheadEnd(BlockPos newPosition) {
        BlockPos posBelow = newPosition.below();
        BlockState stateBelow = this.level.getBlockState(posBelow);
        Block blockBelow = stateBelow.getBlock();
        boolean isAirOrTrunk = stateBelow.canBeReplaced() || blockBelow.equals(BlockContent.PUMP_TRUNK_BLOCK);
        boolean isFluid = !stateBelow.getFluidState().isEmpty();
        return isFluid || !isAirOrTrunk;
    }

    private void startLiquidSearch(BlockPos start) {
        FluidState state = this.level.getFluidState(start);
        if (!state.isSource()) {
            return;
        }
        this.searchInstance = new FloodFillSearch(start, this.level, state.getType());
        this.searchActive = true;
        Oritech.LOGGER.debug("starting search at: " + String.valueOf(start) + " " + String.valueOf(state.getType()) + " " + state.isSource());
    }

    private void finishSearch() {
        Oritech.LOGGER.debug("search finished, found: " + this.searchInstance.foundTargets.size());
        this.pendingLiquidPositions = this.searchInstance.foundTargets;
        this.initialized = true;
        this.searchInstance = null;
    }

    @Override
    public FluidApi.FluidStorage getFluidStorage(Direction direction) {
        return this.fluidStorage;
    }

    @Override
    public EnergyApi.EnergyStorage getEnergyStorage(Direction direction) {
        return this.energyStorage;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(this.animationController);
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.animatableInstanceCache;
    }

    private AnimationController<PumpBlockEntity> getAnimationController() {
        return new AnimationController((GeoAnimatable)this, state -> {
            if (this.isBusy()) {
                return state.setAndContinue(MachineBlockEntity.WORKING);
            }
            return state.setAndContinue(MachineBlockEntity.IDLE);
        });
    }

    private static class FloodFillSearch {
        final HashSet<BlockPos> checkedPositions = new HashSet();
        final HashSet<BlockPos> nextTargets = new HashSet();
        final Deque<BlockPos> foundTargets = new ArrayDeque<BlockPos>();
        final Level world;
        final Fluid fluidType;

        public FloodFillSearch(BlockPos startPosition, Level world, Fluid fluidType) {
            this.world = world;
            this.fluidType = fluidType;
            this.nextTargets.add(startPosition);
        }

        public boolean nextGeneration() {
            HashSet currentGeneration = (HashSet)this.nextTargets.clone();
            boolean earlyStop = false;
            for (BlockPos target : currentGeneration) {
                if (this.isValidTarget(target)) {
                    this.foundTargets.addLast(target);
                    this.addNeighborsToQueue(target);
                    if (this.checkForEarlyStop(target)) {
                        earlyStop = true;
                    }
                }
                this.checkedPositions.add(target);
                this.nextTargets.remove(target);
            }
            if (this.cutoffSearch() || earlyStop) {
                this.nextTargets.clear();
            }
            return this.nextTargets.isEmpty();
        }

        private boolean checkForEarlyStop(BlockPos target) {
            return this.world.getFluidState(target).getType().isSame((Fluid)Fluids.WATER);
        }

        private boolean cutoffSearch() {
            return this.foundTargets.size() >= 100000;
        }

        private boolean isValidTarget(BlockPos target) {
            FluidState state = this.world.getFluidState(target);
            return !state.isEmpty() && state.is(this.fluidType);
        }

        private void addNeighborsToQueue(BlockPos self) {
            for (BlockPos neighbor : this.getNeighbors(self)) {
                if (this.checkedPositions.contains(neighbor)) continue;
                this.nextTargets.add(neighbor);
            }
        }

        private List<BlockPos> getNeighbors(BlockPos pos) {
            return List.of(pos.below(), pos.north(), pos.east(), pos.south(), pos.west());
        }
    }
}

