/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.block.entity.processing;

import dev.architectury.hooks.fluid.FluidStackHooks;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import rearth.oritech.Oritech;
import rearth.oritech.api.fluid.FluidApi;
import rearth.oritech.api.fluid.containers.SimpleFluidStorage;
import rearth.oritech.api.networking.NetworkedBlockEntity;
import rearth.oritech.api.networking.SyncField;
import rearth.oritech.api.networking.SyncType;
import rearth.oritech.block.base.entity.MultiblockMachineEntity;
import rearth.oritech.block.entity.processing.CentrifugeBlockEntity;
import rearth.oritech.client.init.ModScreens;
import rearth.oritech.client.init.ParticleContent;
import rearth.oritech.init.BlockEntitiesContent;
import rearth.oritech.init.TagContent;
import rearth.oritech.init.recipes.OritechRecipe;
import rearth.oritech.init.recipes.OritechRecipeType;
import rearth.oritech.init.recipes.RecipeContent;
import rearth.oritech.util.FluidIngredient;
import rearth.oritech.util.InventorySlotAssignment;
import rearth.oritech.util.ScreenProvider;

public class CoolerBlockEntity
extends MultiblockMachineEntity
implements FluidApi.BlockProvider {
    private boolean inColdArea;
    private boolean initialized = false;
    @SyncField(value={SyncType.GUI_TICK})
    public final SimpleFluidStorage fluidStorage = new SimpleFluidStorage(4L * FluidStackHooks.bucketAmount(), this::setChanged);

    public CoolerBlockEntity(BlockPos pos, BlockState state) {
        super(BlockEntitiesContent.COOLER_ENTITY, pos, state, Oritech.CONFIG.processingMachines.coolerData.energyPerTick());
    }

    @Override
    public void serverTick(Level world, BlockPos pos, BlockState state, NetworkedBlockEntity blockEntity) {
        super.serverTick(world, pos, state, blockEntity);
        if (!this.initialized) {
            this.initialized = true;
            Holder biome = world.getBiome(pos);
            this.inColdArea = biome.is(TagContent.CONVENTIONAL_COLD);
        }
    }

    @Override
    protected void saveAdditional(CompoundTag nbt, HolderLookup.Provider registryLookup) {
        super.saveAdditional(nbt, registryLookup);
        this.fluidStorage.writeNbt(nbt, "");
    }

    @Override
    protected void loadAdditional(CompoundTag nbt, HolderLookup.Provider registryLookup) {
        super.loadAdditional(nbt, registryLookup);
        this.fluidStorage.readNbt(nbt, "");
    }

    @Override
    protected void useEnergy() {
        super.useEnergy();
        float progress = this.getProgress();
        if ((double)progress < 0.35 || (double)progress > 0.65) {
            return;
        }
        if ((double)this.level.random.nextFloat() > 0.4) {
            return;
        }
        Vec3 emitPosition = Vec3.atCenterOf((Vec3i)this.worldPosition);
        ParticleContent.COOLER_WORKING.spawn(this.level, emitPosition, (Object)2);
    }

    @Override
    protected Optional<RecipeHolder<OritechRecipe>> getRecipe() {
        List candidates = Objects.requireNonNull(this.level).getRecipeManager().getRecipesFor((RecipeType)this.getOwnRecipeType(), this.getInputInventory(), this.level);
        Optional<RecipeHolder<OritechRecipe>> fluidRecipe = candidates.stream().filter(candidate -> CentrifugeBlockEntity.recipeInputMatchesTank(this.fluidStorage.getStack(), (OritechRecipe)candidate.value())).findAny();
        if (fluidRecipe.isPresent()) {
            return fluidRecipe;
        }
        return super.getRecipe();
    }

    @Override
    protected void craftItem(OritechRecipe activeRecipe, List<ItemStack> outputInventory, List<ItemStack> inputInventory) {
        if (!this.processCraftInstance(activeRecipe)) {
            return;
        }
        if (this.supportExtraChambersAuto()) {
            int chamberCount = this.getBaseAddonData().extraChambers();
            for (int i = 0; i < chamberCount && this.processCraftInstance(activeRecipe); ++i) {
            }
        }
    }

    private boolean processCraftInstance(OritechRecipe activeRecipe) {
        List<ItemStack> results = this.getCraftingResults(activeRecipe);
        if (results.isEmpty()) {
            return false;
        }
        ItemStack result = results.getFirst();
        if (((ItemStack)this.inventory.heldStacks.getFirst()).getCount() + result.getCount() > 64) {
            return false;
        }
        FluidIngredient input = activeRecipe.getFluidInput();
        long extracted = this.fluidStorage.extract(this.fluidStorage.getStack().copyWithAmount(input.amount()), true);
        if (extracted == activeRecipe.getFluidInput().amount()) {
            this.fluidStorage.extract(this.fluidStorage.getStack().copyWithAmount(input.amount()), false);
            if (((ItemStack)this.inventory.heldStacks.getFirst()).isEmpty()) {
                this.inventory.heldStacks.set(0, (Object)result.copy());
            } else {
                ((ItemStack)this.inventory.heldStacks.getFirst()).grow(result.getCount());
            }
            return true;
        }
        return false;
    }

    @Override
    public float getSpeedMultiplier() {
        float biomeBonus = this.inColdArea ? 0.5f : 1.0f;
        return super.getSpeedMultiplier() * biomeBonus;
    }

    @Override
    public float getEfficiencyMultiplier() {
        float biomeBonus = this.inColdArea ? 0.5f : 1.0f;
        return super.getEfficiencyMultiplier() * biomeBonus;
    }

    @Override
    public long getDefaultCapacity() {
        return Oritech.CONFIG.processingMachines.coolerData.energyCapacity();
    }

    @Override
    public long getDefaultInsertRate() {
        return Oritech.CONFIG.processingMachines.coolerData.maxEnergyInsertion();
    }

    @Override
    protected OritechRecipeType getOwnRecipeType() {
        return RecipeContent.COOLER;
    }

    @Override
    public InventorySlotAssignment getSlotAssignments() {
        return new InventorySlotAssignment(0, 0, 0, 1);
    }

    @Override
    public List<ScreenProvider.GuiSlot> getGuiSlots() {
        return List.of(new ScreenProvider.GuiSlot(0, 117, 36, true));
    }

    @Override
    public MenuType<?> getScreenHandlerType() {
        return ModScreens.COOLER_SCREEN;
    }

    @Override
    public int getInventorySize() {
        return 1;
    }

    @Override
    public List<Vec3i> getCorePositions() {
        return List.of(new Vec3i(0, 0, -1));
    }

    @Override
    public List<Vec3i> getAddonSlots() {
        return List.of(new Vec3i(0, 0, -2));
    }

    @Override
    public FluidApi.FluidStorage getFluidStorage(@Nullable Direction direction) {
        return this.fluidStorage;
    }
}

