/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.client.other;

import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.BitSet;
import java.util.List;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.ModelBlockRenderer;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public class OreFinderRenderer {
    public static List<BlockPos> renderedBlocks;
    public static long receivedAt;
    private static final RenderType OVERLAY;

    public static void doRender(PoseStack matrices, Camera camera, MultiBufferSource vertexConsumers) {
        ClientLevel world = Minecraft.getInstance().level;
        if (world == null || renderedBlocks == null) {
            return;
        }
        long age = world.getGameTime() - receivedAt;
        if (age > 15L) {
            return;
        }
        for (BlockPos pos : renderedBlocks) {
            BlockState state = world.getBlockState(pos);
            matrices.pushPose();
            matrices.translate((double)pos.getX() - camera.getPosition().x, (double)pos.getY() - camera.getPosition().y, (double)pos.getZ() - camera.getPosition().z);
            ModelBlockRenderer renderer = Minecraft.getInstance().getBlockRenderer().getModelRenderer();
            VertexConsumer vertexProvider = vertexConsumers.getBuffer(OVERLAY);
            OreFinderRenderer.tesselateWithoutAO(renderer, (BlockAndTintGetter)world, Minecraft.getInstance().getBlockRenderer().getBlockModel(state), state, pos, matrices, vertexProvider, false, world.random, 0L, 0);
            matrices.popPose();
        }
    }

    public static void tesselateWithoutAO(ModelBlockRenderer renderer, BlockAndTintGetter level, BakedModel model, BlockState state, BlockPos pos, PoseStack poseStack, VertexConsumer consumer, boolean checkSides, RandomSource random, long seed, int packedOverlay) {
        BitSet bitSet = new BitSet(3);
        BlockPos.MutableBlockPos mutableBlockPos = pos.mutable();
        for (Direction direction : LevelRenderer.DIRECTIONS) {
            random.setSeed(seed);
            List list = model.getQuads(state, direction, random);
            if (list.isEmpty()) continue;
            mutableBlockPos.setWithOffset((Vec3i)pos, direction);
            if (checkSides && !Block.shouldRenderFace((BlockState)state, (BlockGetter)level, (BlockPos)pos, (Direction)direction, (BlockPos)mutableBlockPos)) continue;
            int i = 0xF000F0;
            renderer.renderModelFaceFlat(level, state, pos, i, packedOverlay, false, poseStack, consumer, list, bitSet);
        }
        random.setSeed(seed);
        List list2 = model.getQuads(state, null, random);
        if (!list2.isEmpty()) {
            int i = 0xF000F0;
            renderer.renderModelFaceFlat(level, state, pos, i, packedOverlay, true, poseStack, consumer, list2, bitSet);
        }
    }

    static {
        OVERLAY = RenderType.create((String)"overlay", (VertexFormat)DefaultVertexFormat.BLOCK, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)0x400000, (boolean)true, (boolean)false, (RenderType.CompositeState)RenderType.CompositeState.builder().setLightmapState(RenderStateShard.LIGHTMAP).setShaderState(RenderStateShard.RENDERTYPE_SOLID_SHADER).setTextureState((RenderStateShard.EmptyTextureStateShard)RenderStateShard.BLOCK_SHEET_MIPPED).setCullState(RenderStateShard.CULL).setOutputState(RenderStateShard.OUTLINE_TARGET).createCompositeState(false));
    }
}

