/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.client.ui;

import io.wispforest.owo.client.screens.SlotGenerator;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import rearth.oritech.api.energy.EnergyApi;
import rearth.oritech.api.fluid.FluidApi;
import rearth.oritech.api.fluid.containers.SimpleFluidStorage;
import rearth.oritech.api.networking.NetworkedBlockEntity;
import rearth.oritech.api.networking.SyncType;
import rearth.oritech.block.base.entity.UpgradableGeneratorBlockEntity;
import rearth.oritech.block.entity.generators.SteamEngineEntity;
import rearth.oritech.client.ui.BasicMachineOutputSlot;
import rearth.oritech.util.ScreenProvider;

public class BasicMachineScreenHandler
extends AbstractContainerMenu {
    @NotNull
    protected final Inventory playerInventory;
    @NotNull
    protected final Container inventory;
    @NotNull
    protected final EnergyApi.EnergyStorage energyStorage;
    @NotNull
    protected final BlockPos blockPos;
    @NotNull
    public final ScreenProvider screenData;
    @Nullable
    protected final FluidApi.SingleSlotStorage steamStorage;
    @Nullable
    protected final FluidApi.SingleSlotStorage waterStorage;
    @Nullable
    protected FluidApi.SingleSlotStorage mainFluidContainer;
    protected BlockState machineBlock;
    public BlockEntity blockEntity;
    protected List<Integer> armorSlots;

    public BasicMachineScreenHandler(int syncId, Inventory inventory, FriendlyByteBuf buf) {
        this(syncId, inventory, Objects.requireNonNull(inventory.player.level().getBlockEntity(buf.readBlockPos())));
    }

    /*
     * Unable to fully structure code
     */
    public BasicMachineScreenHandler(int syncId, Inventory playerInventory, BlockEntity blockEntity) {
        super(((ScreenProvider)blockEntity).getScreenHandlerType(), syncId);
        this.screenData = (ScreenProvider)blockEntity;
        this.blockPos = blockEntity.getBlockPos();
        this.inventory = this.screenData.getDisplayedInventory();
        if (this.inventory != null) {
            this.inventory.startOpen(playerInventory.player);
        }
        this.playerInventory = playerInventory;
        if (blockEntity instanceof EnergyApi.BlockProvider) {
            energyProvider = (EnergyApi.BlockProvider)blockEntity;
            this.energyStorage = energyProvider.getEnergyStorage(null);
        } else {
            this.energyStorage = null;
        }
        if (blockEntity instanceof FluidApi.BlockProvider && (var6_5 = (blockProvider = (FluidApi.BlockProvider)blockEntity).getFluidStorage(null)) instanceof SimpleFluidStorage) {
            container = (SimpleFluidStorage)var6_5;
            this.mainFluidContainer = container;
        } else {
            this.mainFluidContainer = null;
        }
        this.machineBlock = blockEntity.getBlockState();
        this.blockEntity = blockEntity;
        var6_5 = this.blockEntity;
        if (!(var6_5 instanceof UpgradableGeneratorBlockEntity)) ** GOTO lbl-1000
        generatorEntity = (UpgradableGeneratorBlockEntity)var6_5;
        if (generatorEntity.isProducingSteam) {
            this.waterStorage = generatorEntity.boilerStorage.getInputContainer();
            this.steamStorage = generatorEntity.boilerStorage.getOutputContainer();
        } else if ((var6_5 = this.blockEntity) instanceof SteamEngineEntity) {
            steamEngineEntity = (SteamEngineEntity)var6_5;
            this.waterStorage = steamEngineEntity.boilerStorage.getOutputContainer();
            this.steamStorage = steamEngineEntity.boilerStorage.getInputContainer();
        } else {
            this.steamStorage = null;
            this.waterStorage = null;
        }
        this.buildItemSlots();
    }

    private void buildItemSlots() {
        for (ScreenProvider.GuiSlot slot : this.screenData.getGuiSlots()) {
            this.addMachineSlot(slot.index(), slot.x(), slot.y(), slot.output());
        }
        SlotGenerator.begin(x$0 -> this.addSlot((Slot)x$0), (int)8, (int)84).playerInventory(this.playerInventory);
        if (this.screenData.showArmor()) {
            this.armorSlots = new ArrayList<Integer>(5);
            for (int i = 0; i < this.playerInventory.armor.size() + 1; ++i) {
                final int iteration = i;
                Slot index = this.addSlot(new Slot(this, (Container)this.playerInventory, 36 + i, -20, i * 19){

                    public boolean mayPlace(ItemStack stack) {
                        if (iteration == 4) {
                            return super.mayPlace(stack);
                        }
                        Item item = stack.getItem();
                        if (item instanceof ArmorItem) {
                            ArmorItem armorItem = (ArmorItem)item;
                            return super.mayPlace(stack) && armorItem.getEquipmentSlot().getIndex() == iteration;
                        }
                        return false;
                    }
                });
                this.armorSlots.add(index.index);
            }
        }
    }

    public void addMachineSlot(int inventorySlot, int x, int y, boolean output) {
        if (output) {
            this.addSlot(new BasicMachineOutputSlot(this.inventory, inventorySlot, x, y));
        } else {
            this.addSlot(new Slot(this.inventory, inventorySlot, x, y));
        }
    }

    public ItemStack quickMoveStack(Player player, int invSlot) {
        ItemStack newStack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(invSlot);
        if (slot.hasItem()) {
            ItemStack originalStack = slot.getItem();
            newStack = originalStack.copy();
            if (invSlot < this.inventory.getContainerSize() || invSlot >= this.inventory.getContainerSize() + 36 ? !this.moveItemStackTo(originalStack, this.getPlayerInvStartSlot(newStack), this.getPlayerInvEndSlot(newStack), true) : !this.moveItemStackTo(originalStack, this.getMachineInvStartSlot(newStack), this.getMachineInvEndSlot(newStack), false)) {
                return ItemStack.EMPTY;
            }
            if (originalStack.isEmpty()) {
                slot.setByPlayer(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
        }
        return newStack;
    }

    public int getPlayerInvStartSlot(ItemStack stack) {
        return this.inventory.getContainerSize();
    }

    public int getPlayerInvEndSlot(ItemStack stack) {
        if (this.screenData.showArmor()) {
            return this.slots.size() - 1;
        }
        return this.slots.size();
    }

    public int getMachineInvStartSlot(ItemStack stack) {
        return 0;
    }

    public int getMachineInvEndSlot(ItemStack stack) {
        return this.inventory.getContainerSize();
    }

    public boolean stillValid(Player player) {
        return this.inventory.stillValid(player);
    }

    @NotNull
    public BlockPos getBlockPos() {
        return this.blockPos;
    }

    public boolean showRedstoneAddon() {
        return this.screenData.hasRedstoneControlAvailable();
    }

    public void broadcastChanges() {
        BlockEntity blockEntity = this.blockEntity;
        if (blockEntity instanceof NetworkedBlockEntity) {
            NetworkedBlockEntity networkedBlockEntity = (NetworkedBlockEntity)blockEntity;
            networkedBlockEntity.sendUpdate(SyncType.GUI_TICK, (ServerPlayer)this.player());
        }
        super.broadcastChanges();
    }
}

