/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.item.tools.armor;

import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import rearth.oritech.Oritech;
import rearth.oritech.item.tools.armor.BackstorageExoArmorItem;
import rearth.oritech.item.tools.armor.BaseJetpackItem;

public class JetpackExoArmorItem
extends BackstorageExoArmorItem
implements BaseJetpackItem {
    public JetpackExoArmorItem(Holder<ArmorMaterial> material, ArmorItem.Type type, Item.Properties settings) {
        super(material, type, settings);
    }

    @Override
    public void inventoryTick(ItemStack stack, Level world, Entity entity, int slot, boolean selected) {
        if (world.isClientSide) {
            this.tickJetpack(stack, entity, world);
        } else {
            super.inventoryTick(stack, world, entity, slot, selected);
        }
    }

    @Override
    public ResourceLocation getModel() {
        return Oritech.id("armor/exo_armor_jetpack");
    }

    @Override
    public int getBarColor(ItemStack stack) {
        return this.getJetpackBarColor(stack);
    }

    @Override
    public int getBarWidth(ItemStack stack) {
        return this.getJetpackBarStep(stack);
    }

    @Override
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag type) {
        MutableComponent hint = Component.translatable((String)"tooltip.oritech.jetpack_usage").withStyle(new ChatFormatting[]{ChatFormatting.GRAY, ChatFormatting.ITALIC});
        tooltip.add((Component)hint);
        hint = Component.translatable((String)"tooltip.oritech.jetpack_usage2").withStyle(new ChatFormatting[]{ChatFormatting.GRAY, ChatFormatting.ITALIC});
        tooltip.add((Component)hint);
        super.appendHoverText(stack, context, tooltip, type);
        this.addJetpackTooltip(stack, tooltip, false);
    }

    @Override
    public boolean requireUpward() {
        return false;
    }

    @Override
    public float getSpeed() {
        return Oritech.CONFIG.exoJetpack.speed();
    }

    @Override
    public int getRfUsage() {
        return Oritech.CONFIG.exoJetpack.energyUsage();
    }

    @Override
    public int getFuelUsage() {
        return Oritech.CONFIG.exoJetpack.fuelUsage();
    }

    @Override
    public long getFuelCapacity() {
        return Oritech.CONFIG.exoJetpack.fuelCapacity();
    }

    @Override
    public long getEnergyCapacity(ItemStack stack) {
        return Oritech.CONFIG.exoJetpack.energyCapacity();
    }

    @Override
    public long getEnergyMaxInput(ItemStack stack) {
        return Oritech.CONFIG.exoJetpack.chargeSpeed();
    }
}

