/*
 * Decompiled with CFR 0.152.
 */
package com.leclowndu93150.particular.particles.splashes;

import com.leclowndu93150.particular.Particles;
import com.leclowndu93150.particular.mixin.AccessorBillboardParticle;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.NoRenderParticle;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.tags.FluidTags;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

public class WaterSplashEmitterParticle
extends NoRenderParticle {
    private final float speed;
    private final float width;
    private final float height;

    WaterSplashEmitterParticle(ClientLevel clientWorld, double x, double y, double z, float width, float speed) {
        super(clientWorld, x, y, z);
        speed = Math.min(2.0f, speed);
        this.gravity = 0.0f;
        this.lifetime = 24;
        this.speed = speed;
        this.width = width;
        this.height = speed / 2.0f + width / 3.0f;
        clientWorld.addParticle((ParticleOptions)Particles.WATER_SPLASH.get(), x, y, z, (double)width, (double)this.height, 0.0);
        clientWorld.addParticle((ParticleOptions)Particles.WATER_SPLASH_FOAM.get(), x, y, z, (double)width, (double)this.height, 0.0);
        clientWorld.addParticle((ParticleOptions)Particles.WATER_SPLASH_RING.get(), x, y, z, (double)width, 0.0, 0.0);
        if ((double)speed > 0.5) {
            this.splash(width, 0.1875f + speed * 1.0f / 8.0f + width / 6.0f, 0.15f);
        } else {
            this.remove();
        }
    }

    public void tick() {
        super.tick();
        if (this.age == 8) {
            this.level.addParticle((ParticleOptions)Particles.WATER_SPLASH.get(), this.x, this.y, this.z, (double)(this.width * 0.66f), (double)(this.height * 2.0f), 0.0);
            this.level.addParticle((ParticleOptions)Particles.WATER_SPLASH_FOAM.get(), this.x, this.y, this.z, (double)(this.width * 0.66f), (double)(this.height * 2.0f), 0.0);
            this.level.addParticle((ParticleOptions)Particles.WATER_SPLASH_RING.get(), this.x, this.y, this.z, (double)(this.width * 0.66f), 0.0, 0.0);
            this.splash(this.width * 0.66f, 0.375f + this.speed * 1.0f / 8.0f + this.width / 6.0f, 0.05f);
        }
        if (!this.level.getFluidState(BlockPos.containing((double)this.x, (double)this.y, (double)this.z)).is(FluidTags.WATER)) {
            this.remove();
        }
    }

    private void splash(float width, float speed, float spread) {
        int i = 0;
        while ((float)i < width * 20.0f) {
            Particle droplet = Minecraft.getInstance().particleEngine.createParticle((ParticleOptions)ParticleTypes.FALLING_WATER, this.x, this.y + 0.0625, this.z, 0.0, 0.0, 0.0);
            if (droplet != null) {
                double xVel = this.random.triangle(0.0, (double)spread);
                double yVel = (double)speed * this.random.triangle(1.0, 0.25);
                double zVel = this.random.triangle(0.0, (double)spread);
                droplet.setPos(this.x + xVel / (double)spread * (double)width, this.y + 0.0625, this.z + zVel / (double)spread * (double)width);
                droplet.setParticleSpeed(xVel, yVel, zVel);
                droplet.setColor(1.0f, 1.0f, 1.0f);
                ((AccessorBillboardParticle)droplet).setQuadSize(0.125f);
            }
            ++i;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Factory
    implements ParticleProvider<SimpleParticleType> {
        public Factory(SpriteSet provider) {
        }

        @Nullable
        public Particle createParticle(SimpleParticleType SimpleParticleType2, ClientLevel clientWorld, double x, double y, double z, double g, double h, double i) {
            return new WaterSplashEmitterParticle(clientWorld, x, y, z, (float)g, (float)h);
        }
    }
}

