/*
 * Decompiled with CFR 0.152.
 */
package net.manmaed.petrock.client.render.layers;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.manmaed.petrock.client.model.PRModels;
import net.manmaed.petrock.client.render.layers.TNTBottomLayer;
import net.manmaed.petrock.client.render.layers.TNTTopLayer;
import net.manmaed.petrock.client.render.model.ModelTNTSides;
import net.manmaed.petrock.entity.EntityPetRock;
import net.manmaed.petrock.hats.PRHats;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;

public class TNTSidesLayer
extends RenderLayer {
    private static final ResourceLocation skin = ResourceLocation.withDefaultNamespace((String)"textures/block/tnt_side.png");
    private final ModelTNTSides sides;
    private final TNTTopLayer top;
    private final TNTBottomLayer bottom;

    public TNTSidesLayer(RenderLayerParent layerParent, EntityModelSet modelSet) {
        super(layerParent);
        this.sides = new ModelTNTSides(modelSet.bakeLayer(PRModels.TNT_SIDE));
        this.top = new TNTTopLayer(layerParent, modelSet);
        this.bottom = new TNTBottomLayer(layerParent, modelSet);
    }

    public void render(PoseStack poseStack, MultiBufferSource multiBufferSource, int packedLight, Entity entity, float p_117353_, float p_117354_, float p_117355_, float p_117356_, float p_117357_, float p_117358_) {
        VertexConsumer vertexConsumer;
        EntityPetRock entityPetRock = (EntityPetRock)entity;
        String hatData = entityPetRock.getHatData();
        if (hatData.equals("tnt")) {
            poseStack.pushPose();
            poseStack.scale(0.25f, 0.25f, 0.25f);
            if (entityPetRock.getSlowpoke().booleanValue()) {
                poseStack.translate(0.0f, -1.25f, 0.3f);
            } else {
                poseStack.translate(0.0f, 2.25f, 0.0f);
            }
            vertexConsumer = multiBufferSource.getBuffer(RenderType.entityCutout((ResourceLocation)skin));
            this.sides.renderToBuffer(poseStack, vertexConsumer, packedLight, OverlayTexture.NO_OVERLAY);
            this.top.render(poseStack, multiBufferSource, packedLight, entity, p_117353_, p_117354_, p_117355_, p_117356_, p_117357_, p_117358_);
            this.bottom.render(poseStack, multiBufferSource, packedLight, entity, p_117353_, p_117354_, p_117355_, p_117356_, p_117357_, p_117358_);
            poseStack.popPose();
        }
        if (PRHats.tnt && hatData.isEmpty()) {
            poseStack.pushPose();
            poseStack.scale(0.25f, 0.25f, 0.25f);
            if (PRHats.slowpoke) {
                poseStack.translate(0.0f, -1.25f, 0.3f);
            } else {
                poseStack.translate(0.0f, 2.25f, 0.0f);
            }
            vertexConsumer = multiBufferSource.getBuffer(RenderType.entityCutout((ResourceLocation)skin));
            this.sides.renderToBuffer(poseStack, vertexConsumer, packedLight, OverlayTexture.NO_OVERLAY);
            this.top.render(poseStack, multiBufferSource, packedLight, entity, p_117353_, p_117354_, p_117355_, p_117356_, p_117357_, p_117358_);
            this.bottom.render(poseStack, multiBufferSource, packedLight, entity, p_117353_, p_117354_, p_117355_, p_117356_, p_117357_, p_117358_);
            poseStack.popPose();
        }
    }
}

