/*
 * Decompiled with CFR 0.152.
 */
package com.heaser.pipeconnector.utils;

import com.heaser.pipeconnector.constants.BridgeType;
import com.heaser.pipeconnector.utils.NodeParameter;
import com.heaser.pipeconnector.utils.TagUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.item.ItemStack;

public class BuildParameters {
    public int depth;
    public List<NodeParameter> nodes;
    public BridgeType bridgeType;
    public boolean utilizeExistingPipes;
    public boolean avoidInventoryBlocks;
    public String dimension;

    public BuildParameters() {
        this.depth = -1;
        this.nodes = new ArrayList<NodeParameter>();
        this.dimension = "";
        this.bridgeType = BridgeType.DEFAULT;
        this.utilizeExistingPipes = true;
        this.avoidInventoryBlocks = false;
    }

    public BuildParameters(ItemStack pipeConnectorItem) {
        this.nodes = TagUtils.getNodesFromStack(pipeConnectorItem);
        this.depth = TagUtils.getDepthFromStack(pipeConnectorItem);
        this.dimension = TagUtils.getDimension(pipeConnectorItem);
        this.bridgeType = TagUtils.getBridgeType(pipeConnectorItem);
        this.utilizeExistingPipes = TagUtils.getUtilizeExistingPipes(pipeConnectorItem);
        this.avoidInventoryBlocks = TagUtils.getAvoidInventoryBlocks(pipeConnectorItem);
    }

    public BuildParameters(int depth, List<NodeParameter> nodes, String dimension, BridgeType bridgeType, boolean utilizeExistingPipes, boolean avoidInventoryBlocks) {
        this.depth = depth;
        this.nodes = (List)new ArrayList<NodeParameter>(nodes).clone();
        this.dimension = dimension;
        this.bridgeType = bridgeType;
        this.utilizeExistingPipes = utilizeExistingPipes;
        this.avoidInventoryBlocks = avoidInventoryBlocks;
    }

    public boolean equals(BuildParameters other) {
        boolean nodesEqual;
        boolean depthEqual = other.depth == this.depth;
        boolean isDimensionEqual = other.dimension.equals(this.dimension);
        boolean isBridgeTypeEqual = other.bridgeType == this.bridgeType;
        boolean isUtilizeExistingPipesEqual = other.utilizeExistingPipes == this.utilizeExistingPipes;
        boolean isAvoidInventoryBlocksEqual = other.avoidInventoryBlocks == this.avoidInventoryBlocks;
        boolean bl = nodesEqual = other.nodes.size() == this.nodes.size();
        if (nodesEqual) {
            for (int index = 0; index < this.nodes.size(); ++index) {
                NodeParameter otherNode = other.nodes.get(index);
                NodeParameter node = this.nodes.get(index);
                nodesEqual = nodesEqual && otherNode.equals(node);
            }
        }
        return depthEqual && nodesEqual && isDimensionEqual && isBridgeTypeEqual && isUtilizeExistingPipesEqual && isAvoidInventoryBlocksEqual;
    }
}

