/*
 * Decompiled with CFR 0.152.
 */
package com.davenonymous.pipegoggles.lib.gui.tooltip;

import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.tooltip.TooltipComponent;

public class BackgroundTooltipComponent
implements TooltipComponent,
ClientTooltipComponent {
    ClientTooltipComponent component;
    ResourceLocation backgroundImage;
    int paddingTop = 6;
    int paddingRight = 6;
    int paddingBottom = 4;
    int paddingLeft = 6;

    public BackgroundTooltipComponent(ClientTooltipComponent component, ResourceLocation backgroundImage) {
        this.component = component;
        this.backgroundImage = backgroundImage;
    }

    public BackgroundTooltipComponent setPadding(int padding) {
        this.paddingTop = padding;
        this.paddingRight = padding;
        this.paddingBottom = padding;
        this.paddingLeft = padding;
        return this;
    }

    public BackgroundTooltipComponent setPadding(int paddingTop, int paddingRight, int paddingBottom, int paddingLeft) {
        this.paddingTop = paddingTop;
        this.paddingRight = paddingRight;
        this.paddingBottom = paddingBottom;
        this.paddingLeft = paddingLeft;
        return this;
    }

    public BackgroundTooltipComponent setPaddingHorizontal(int padding) {
        this.paddingLeft = padding;
        this.paddingRight = padding;
        return this;
    }

    public BackgroundTooltipComponent setPaddingVertical(int padding) {
        this.paddingTop = padding;
        this.paddingBottom = padding;
        return this;
    }

    public int getHeight() {
        return this.component.getHeight() + this.paddingTop + this.paddingBottom;
    }

    public int getWidth(Font font) {
        return this.component.getWidth(font) + this.paddingLeft + this.paddingRight;
    }

    public void renderImage(Font font, int x, int y, GuiGraphics guiGraphics) {
        guiGraphics.blitSprite(this.backgroundImage, x, y, this.getWidth(font), this.getHeight());
        this.component.renderImage(font, x + this.paddingLeft, y + this.paddingTop, guiGraphics);
    }
}

