/*
 * Decompiled with CFR 0.152.
 */
package com.davenonymous.pipegoggles.lib.gui.tooltip;

import com.davenonymous.pipegoggles.lib.gui.tooltip.BoxAlignment;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.world.inventory.tooltip.TooltipComponent;

public class TableTooltipComponent
implements TooltipComponent,
ClientTooltipComponent {
    private final Table<Integer, Integer, CellData> components = HashBasedTable.create();
    private final Map<Integer, Integer> rowHeights = new HashMap<Integer, Integer>();
    private final Map<Integer, Integer> colWidths = new HashMap<Integer, Integer>();
    private int highestColumn = 0;
    private int longestRow = 0;
    private int verticalPadding = 2;
    private int horizontalPadding = 4;

    private void putComponent(int row, int col, TooltipComponent component) {
        this.putComponent(row, col, new CellData(component));
    }

    private void putComponent(int row, int col, CellData cell) {
        this.components.put((Object)row, (Object)col, (Object)cell);
        this.updateTableRowColsToComponent(row, col, cell.component());
    }

    private void updateTableRowColsToComponent(int row, int col, TooltipComponent component) {
        if (!(component instanceof ClientTooltipComponent)) {
            return;
        }
        ClientTooltipComponent clientTooltipComponent = (ClientTooltipComponent)component;
        int height = clientTooltipComponent.getHeight();
        int width = clientTooltipComponent.getWidth(Minecraft.getInstance().font);
        if (height > this.rowHeights.getOrDefault(row, 0)) {
            this.rowHeights.put(row, height);
        }
        if (width > this.colWidths.getOrDefault(col, 0)) {
            this.colWidths.put(col, width);
        }
        this.updateTableSize();
    }

    private void updateTableSize() {
        int totalHeight = this.rowHeights.values().stream().mapToInt(Integer::intValue).sum() + this.rowHeights.size() * this.verticalPadding;
        int totalWidth = this.colWidths.values().stream().mapToInt(Integer::intValue).sum() + this.colWidths.size() * this.verticalPadding;
        this.highestColumn = totalHeight;
        this.longestRow = totalWidth;
    }

    public TableTooltipComponent forCellInRow(int row, CellConsumer consumer) {
        Iterator iterator = this.components.columnKeySet().iterator();
        while (iterator.hasNext()) {
            CellData cell;
            int col = (Integer)iterator.next();
            if (!this.components.contains((Object)row, (Object)col) || (cell = (CellData)this.components.get((Object)row, (Object)col)) == null) continue;
            consumer.accept(row, col, cell.component(), cell.vertical, cell.horizontal);
        }
        return this;
    }

    public TableTooltipComponent forCellInColumn(int col, CellConsumer consumer) {
        Iterator iterator = this.components.rowKeySet().iterator();
        while (iterator.hasNext()) {
            CellData cell;
            int row = (Integer)iterator.next();
            if (!this.components.contains((Object)row, (Object)col) || (cell = (CellData)this.components.get((Object)row, (Object)col)) == null) continue;
            consumer.accept(row, col, cell.component(), cell.vertical, cell.horizontal);
        }
        return this;
    }

    public TableTooltipComponent forAllCells(CellConsumer consumer) {
        Iterator iterator = this.components.rowKeySet().iterator();
        while (iterator.hasNext()) {
            int row = (Integer)iterator.next();
            Iterator iterator2 = this.components.columnKeySet().iterator();
            while (iterator2.hasNext()) {
                CellData cell;
                int col = (Integer)iterator2.next();
                if (!this.components.contains((Object)row, (Object)col) || (cell = (CellData)this.components.get((Object)row, (Object)col)) == null) continue;
                consumer.accept(row, col, cell.component(), cell.vertical, cell.horizontal);
            }
        }
        return this;
    }

    public TableTooltipComponent updateCellSizes() {
        this.rowHeights.clear();
        this.colWidths.clear();
        this.forAllCells((row, col, component, vertical, horizontal) -> this.updateTableRowColsToComponent(row, col, component));
        return this;
    }

    public TableTooltipComponent addRow(TooltipComponent ... component) {
        int rows = this.components.rowKeySet().size();
        for (int i = 0; i < component.length; ++i) {
            this.putComponent(rows, i, component[i]);
        }
        return this;
    }

    public TableTooltipComponent addRow(List<TooltipComponent> components) {
        return this.addRow(components.toArray(new TooltipComponent[0]));
    }

    public TableTooltipComponent addColumn(TooltipComponent ... component) {
        int cols = this.components.columnKeySet().size();
        for (int i = 0; i < component.length; ++i) {
            this.putComponent(i, cols, component[i]);
        }
        return this;
    }

    public TableTooltipComponent setCellAlignment(int row, int col, BoxAlignment vertical, BoxAlignment horizontal) {
        if (!this.components.contains((Object)row, (Object)col) || this.components.get((Object)row, (Object)col) == null) {
            this.putComponent(row, col, new CellData(null, vertical, horizontal));
        } else {
            this.putComponent(row, col, ((CellData)this.components.get((Object)row, (Object)col)).withAlignment(vertical, horizontal));
        }
        return this;
    }

    public TableTooltipComponent setCellData(int row, int col, TooltipComponent component) {
        if (!this.components.contains((Object)row, (Object)col) || this.components.get((Object)row, (Object)col) == null) {
            this.putComponent(row, col, new CellData(component));
        } else {
            this.putComponent(row, col, ((CellData)this.components.get((Object)row, (Object)col)).withComponent(component));
        }
        return this;
    }

    public TooltipComponent getCellData(int row, int col) {
        if (!this.components.contains((Object)row, (Object)col) || this.components.get((Object)row, (Object)col) == null) {
            return null;
        }
        return ((CellData)this.components.get((Object)Integer.valueOf((int)row), (Object)Integer.valueOf((int)col))).component;
    }

    public TableTooltipComponent setVerticalPadding(int verticalPadding) {
        this.verticalPadding = verticalPadding;
        return this;
    }

    public TableTooltipComponent setHorizontalPadding(int horizontalPadding) {
        this.horizontalPadding = horizontalPadding;
        return this;
    }

    public int count() {
        return this.components.size();
    }

    public int rows() {
        return this.components.rowKeySet().size();
    }

    public int cols() {
        return this.components.columnKeySet().size();
    }

    public TableTooltipComponent clear() {
        this.components.clear();
        this.rowHeights.clear();
        this.colWidths.clear();
        return this;
    }

    public void renderImage(Font font, int x, int y, GuiGraphics guiGraphics) {
        int yPos = y;
        Iterator iterator = this.components.rowKeySet().iterator();
        while (iterator.hasNext()) {
            int row = (Integer)iterator.next();
            if (row > 0) {
                yPos += this.rowHeights.getOrDefault(row - 1, 0) + this.verticalPadding;
            }
            int xPos = x;
            Iterator iterator2 = this.components.columnKeySet().iterator();
            while (iterator2.hasNext()) {
                TooltipComponent component;
                CellData cell;
                int col = (Integer)iterator2.next();
                if (col > 0) {
                    xPos += this.colWidths.getOrDefault(col - 1, 0) + this.horizontalPadding;
                }
                if (!this.components.contains((Object)row, (Object)col) || (cell = (CellData)this.components.get((Object)row, (Object)col)) == null || !((component = cell.component()) instanceof ClientTooltipComponent)) continue;
                ClientTooltipComponent clientComponent = (ClientTooltipComponent)component;
                int xOffset = 0;
                int yOffset = 0;
                if (cell.horizontal == BoxAlignment.CENTER) {
                    xOffset = (this.colWidths.getOrDefault(col, 0) - clientComponent.getWidth(font)) / 2;
                } else if (cell.horizontal == BoxAlignment.END) {
                    xOffset = this.colWidths.getOrDefault(col, 0) - clientComponent.getWidth(font);
                }
                if (cell.vertical == BoxAlignment.CENTER) {
                    yOffset = (this.rowHeights.getOrDefault(row, 0) - clientComponent.getHeight()) / 2;
                } else if (cell.vertical == BoxAlignment.END) {
                    yOffset = this.rowHeights.getOrDefault(row, 0) - clientComponent.getHeight();
                }
                clientComponent.renderImage(font, xPos + xOffset, yPos + yOffset, guiGraphics);
            }
        }
    }

    public int getHeight() {
        return this.highestColumn;
    }

    public int getWidth(Font font) {
        return this.longestRow;
    }

    private record CellData(TooltipComponent component, BoxAlignment vertical, BoxAlignment horizontal) {
        public CellData(TooltipComponent component) {
            this(component, BoxAlignment.CENTER, BoxAlignment.START);
        }

        public CellData withComponent(TooltipComponent component) {
            return new CellData(component, this.vertical, this.horizontal);
        }

        public CellData withAlignment(BoxAlignment vertical, BoxAlignment horizontal) {
            return new CellData(this.component, vertical, horizontal);
        }
    }

    public static interface CellConsumer {
        public void accept(int var1, int var2, TooltipComponent var3, BoxAlignment var4, BoxAlignment var5);
    }
}

