/*
 * Decompiled with CFR 0.152.
 */
package com.ultramega.refinedtypes.autocrafting;

import com.refinedmods.refinedstorage.api.autocrafting.task.ExternalPatternSink;
import com.refinedmods.refinedstorage.api.core.Action;
import com.refinedmods.refinedstorage.api.resource.ResourceAmount;
import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import com.refinedmods.refinedstorage.common.api.autocrafting.PlatformPatternProviderExternalPatternSink;
import com.ultramega.refinedtypes.type.TypeStack;
import com.ultramega.refinedtypes.type.energy.EnergyCapabilityCache;
import com.ultramega.refinedtypes.type.energy.EnergyResource;
import dev.technici4n.grandpower.api.ILongEnergyStorage;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class EnergyPatternProviderExternalPatternSink
implements PlatformPatternProviderExternalPatternSink {
    private static final Logger LOGGER = LoggerFactory.getLogger(EnergyPatternProviderExternalPatternSink.class);
    private final EnergyCapabilityCache capabilityCache;

    EnergyPatternProviderExternalPatternSink(EnergyCapabilityCache capabilityCache) {
        this.capabilityCache = capabilityCache;
    }

    public ExternalPatternSink.Result accept(Collection<ResourceAmount> resources, Action action) {
        return this.capabilityCache.getCapability().map(handler -> this.accept(resources, action, (ILongEnergyStorage)handler)).orElse(ExternalPatternSink.Result.SKIPPED);
    }

    private ExternalPatternSink.Result accept(Collection<ResourceAmount> resources, Action action, ILongEnergyStorage handler) {
        for (ResourceAmount resource : resources) {
            ResourceKey resourceKey = resource.resource();
            if (!(resourceKey instanceof EnergyResource)) continue;
            EnergyResource energyResource = (EnergyResource)resourceKey;
            if (this.accept(action, handler, resource.amount(), energyResource)) continue;
            return ExternalPatternSink.Result.REJECTED;
        }
        return ExternalPatternSink.Result.ACCEPTED;
    }

    private boolean accept(Action action, ILongEnergyStorage handler, long amount, EnergyResource energyResource) {
        long inserted = handler.receive(amount, action == Action.SIMULATE);
        if (inserted != amount) {
            if (action == Action.EXECUTE) {
                LOGGER.warn("{} unexpectedly didn't accept all of {}, the remainder has been voided", (Object)handler, (Object)new TypeStack(energyResource.type(), amount));
            }
            return false;
        }
        return true;
    }

    public boolean isEmpty() {
        return this.capabilityCache.getCapability().map(handler -> handler.getAmount() == 0L).orElse(true);
    }
}

