/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.mekanism;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.refinedmods.refinedstorage.api.network.impl.node.grid.GridOperationsImpl;
import com.refinedmods.refinedstorage.api.network.node.grid.GridOperations;
import com.refinedmods.refinedstorage.api.storage.Actor;
import com.refinedmods.refinedstorage.api.storage.root.RootStorage;
import com.refinedmods.refinedstorage.common.Platform;
import com.refinedmods.refinedstorage.common.api.storage.StorageType;
import com.refinedmods.refinedstorage.common.api.support.resource.PlatformResourceKey;
import com.refinedmods.refinedstorage.common.api.support.resource.ResourceType;
import com.refinedmods.refinedstorage.common.storage.SameTypeStorageType;
import com.refinedmods.refinedstorage.mekanism.ChemicalResource;
import com.refinedmods.refinedstorage.mekanism.MekanismIntegrationIdentifierUtil;
import mekanism.api.chemical.Chemical;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;

public enum ChemicalResourceType implements ResourceType
{
    INSTANCE;

    public static final MapCodec<ChemicalResource> MAP_CODEC;
    public static final Codec<ChemicalResource> CODEC;
    public static final StreamCodec<RegistryFriendlyByteBuf, ChemicalResource> STREAM_CODEC;
    public static final StorageType STORAGE_TYPE;
    private static final MutableComponent TITLE;
    private static final ResourceLocation SPRITE;

    public MapCodec<PlatformResourceKey> getMapCodec() {
        return MAP_CODEC;
    }

    public StreamCodec<RegistryFriendlyByteBuf, PlatformResourceKey> getStreamCodec() {
        return STREAM_CODEC;
    }

    public MutableComponent getTitle() {
        return TITLE;
    }

    public ResourceLocation getSprite() {
        return SPRITE;
    }

    public long normalizeAmount(double amount) {
        return (long)(amount * (double)Platform.INSTANCE.getBucketAmount());
    }

    public double getDisplayAmount(long amount) {
        return (double)amount / (double)Platform.INSTANCE.getBucketAmount();
    }

    public long getInterfaceExportLimit() {
        return Platform.INSTANCE.getBucketAmount() * 16L;
    }

    public GridOperations createGridOperations(RootStorage rootStorage, Actor actor) {
        return new GridOperationsImpl(rootStorage, actor, resource -> Long.MAX_VALUE, Platform.INSTANCE.getBucketAmount());
    }

    static {
        MAP_CODEC = RecordCodecBuilder.mapCodec(ins -> ins.group((App)Chemical.CODEC.fieldOf("chemical").forGetter(ChemicalResource::chemical)).apply((Applicative)ins, ChemicalResource::new));
        CODEC = MAP_CODEC.codec();
        STREAM_CODEC = StreamCodec.composite((StreamCodec)Chemical.STREAM_CODEC, ChemicalResource::chemical, ChemicalResource::new);
        STORAGE_TYPE = new SameTypeStorageType(CODEC, resource -> {
            Chemical chemical;
            if (!(resource instanceof ChemicalResource)) return false;
            ChemicalResource $b$0 = (ChemicalResource)resource;
            try {
                Chemical patt1$temp;
                chemical = patt1$temp = $b$0.chemical();
            }
            catch (Throwable throwable) {
                throw new MatchException(throwable.toString(), throwable);
            }
            if (chemical.hasAttributesWithValidation()) return false;
            return true;
        }, ChemicalResource.class::cast, Platform.INSTANCE.getBucketAmount(), Platform.INSTANCE.getBucketAmount() * 16L);
        TITLE = MekanismIntegrationIdentifierUtil.createMekanismIntegrationTranslation("misc", "resource_type.chemical");
        SPRITE = MekanismIntegrationIdentifierUtil.createMekanismIntegrationIdentifier("chemical_resource_type");
    }
}

