/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.api.network.impl.storage;

import com.refinedmods.refinedstorage.api.network.Network;
import com.refinedmods.refinedstorage.api.network.impl.node.AbstractNetworkNode;
import com.refinedmods.refinedstorage.api.network.impl.storage.StorageConfiguration;
import com.refinedmods.refinedstorage.api.network.storage.StorageNetworkComponent;
import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import com.refinedmods.refinedstorage.api.resource.filter.Filter;
import com.refinedmods.refinedstorage.api.resource.filter.FilterMode;
import com.refinedmods.refinedstorage.api.storage.AccessMode;
import java.util.Set;
import java.util.function.UnaryOperator;

public class NetworkNodeStorageConfiguration
implements StorageConfiguration {
    private final AbstractNetworkNode node;
    private final Filter filter = new Filter();
    private int insertPriority;
    private int extractPriority;
    private AccessMode accessMode = AccessMode.INSERT_EXTRACT;
    private boolean voidExcess;

    public NetworkNodeStorageConfiguration(AbstractNetworkNode node) {
        this.node = node;
    }

    @Override
    public AccessMode getAccessMode() {
        return this.accessMode;
    }

    @Override
    public boolean isVoidExcess() {
        return this.voidExcess;
    }

    @Override
    public void setVoidExcess(boolean voidExcess) {
        this.voidExcess = voidExcess;
    }

    @Override
    public void setAccessMode(AccessMode accessMode) {
        this.accessMode = accessMode;
    }

    @Override
    public FilterMode getFilterMode() {
        return this.filter.getMode();
    }

    @Override
    public boolean isAllowed(ResourceKey resource) {
        return this.filter.isAllowed(resource);
    }

    @Override
    public void setFilters(Set<ResourceKey> filters) {
        this.filter.setFilters(filters);
    }

    @Override
    public void setNormalizer(UnaryOperator<ResourceKey> normalizer) {
        this.filter.setNormalizer(normalizer);
    }

    @Override
    public void setFilterMode(FilterMode filterMode) {
        this.filter.setMode(filterMode);
    }

    @Override
    public void setInsertPriority(int insertPriority) {
        this.insertPriority = insertPriority;
        this.trySortSources();
    }

    @Override
    public void setExtractPriority(int extractPriority) {
        this.extractPriority = extractPriority;
        this.trySortSources();
    }

    private void trySortSources() {
        Network network = this.node.getNetwork();
        if (network == null) {
            return;
        }
        StorageNetworkComponent storage = network.getComponent(StorageNetworkComponent.class);
        storage.sortSources();
    }

    @Override
    public int getInsertPriority() {
        return this.insertPriority;
    }

    @Override
    public int getExtractPriority() {
        return this.extractPriority;
    }

    @Override
    public boolean isActive() {
        return this.node.isActive();
    }
}

