/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.api.storage;

import com.refinedmods.refinedstorage.common.api.RefinedStorageApi;
import com.refinedmods.refinedstorage.common.api.storage.SerializableStorage;
import com.refinedmods.refinedstorage.common.api.storage.StorageBlockEntity;
import com.refinedmods.refinedstorage.common.api.storage.StorageContainerItemHelper;
import com.refinedmods.refinedstorage.common.api.storage.StorageRepository;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.apiguardian.api.API;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@API(status=API.Status.STABLE, since="2.0.0-milestone.1.4")
public abstract class AbstractStorageContainerBlockItem
extends BlockItem {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractStorageContainerBlockItem.class);
    protected final StorageContainerItemHelper helper;

    protected AbstractStorageContainerBlockItem(Block block, Item.Properties properties, StorageContainerItemHelper helper) {
        super(block, properties);
        this.helper = helper;
    }

    public void inventoryTick(ItemStack stack, Level level, Entity entity, int slotId, boolean isSelected) {
        super.inventoryTick(stack, level, entity, slotId, isSelected);
        this.helper.transferStorageIfNecessary(stack, level, entity, this::createStorage);
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        return this.helper.tryDisassembly(level, player, stack, this.createPrimaryDisassemblyByproduct(stack.getCount()), this.createSecondaryDisassemblyByproduct(stack.getCount()));
    }

    protected boolean updateCustomBlockEntityTag(BlockPos pos, Level level, @Nullable Player player, ItemStack stack, BlockState state) {
        if (!level.isClientSide()) {
            this.updateBlockEntityTag(pos, level, stack);
        }
        return super.updateCustomBlockEntityTag(pos, level, player, stack, state);
    }

    private void updateBlockEntityTag(BlockPos pos, Level level, ItemStack stack) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof StorageBlockEntity) {
            StorageBlockEntity blockEntity2 = (StorageBlockEntity)blockEntity;
            this.helper.transferToBlockEntity(stack, blockEntity2);
        } else {
            LOGGER.warn("Storage could not be set, block entity does not exist yet at {}", (Object)pos);
        }
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        super.appendHoverText(stack, context, tooltip, flag);
        StorageRepository storageRepository = RefinedStorageApi.INSTANCE.getClientStorageRepository();
        this.helper.appendToTooltip(stack, storageRepository, tooltip, flag, this::formatAmount, this.getCapacity());
    }

    @Nullable
    protected abstract Long getCapacity();

    protected abstract String formatAmount(long var1);

    protected abstract SerializableStorage createStorage(StorageRepository var1);

    protected abstract ItemStack createPrimaryDisassemblyByproduct(int var1);

    @Nullable
    protected abstract ItemStack createSecondaryDisassemblyByproduct(int var1);
}

