/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.autocrafting;

import com.refinedmods.refinedstorage.common.autocrafting.PatternState;
import com.refinedmods.refinedstorage.common.autocrafting.patterngrid.PatternType;
import com.refinedmods.refinedstorage.common.content.DataComponents;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;

public class PatternItemOverrides
extends ItemOverrides {
    private final BakedModel emptyModel;
    private final BakedModel craftingModel;
    private final BakedModel processingModel;
    private final BakedModel stonecutterModel;
    private final BakedModel smithingTableModel;

    public PatternItemOverrides(ModelBaker modelBaker, BakedModel emptyModel, BakedModel craftingModel, BakedModel processingModel, BakedModel stonecutterModel, BakedModel smithingTableModel) {
        super(modelBaker, null, List.of());
        this.emptyModel = emptyModel;
        this.craftingModel = craftingModel;
        this.processingModel = processingModel;
        this.stonecutterModel = stonecutterModel;
        this.smithingTableModel = smithingTableModel;
    }

    public BakedModel resolve(BakedModel model, ItemStack stack, @Nullable ClientLevel level, @Nullable LivingEntity entity, int seed) {
        PatternState state = (PatternState)stack.get(DataComponents.INSTANCE.getPatternState());
        if (state == null) {
            return this.emptyModel;
        }
        return switch (state.type()) {
            default -> throw new MatchException(null, null);
            case PatternType.CRAFTING -> this.craftingModel;
            case PatternType.PROCESSING -> this.processingModel;
            case PatternType.STONECUTTER -> this.stonecutterModel;
            case PatternType.SMITHING_TABLE -> this.smithingTableModel;
        };
    }
}

