/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.storage;

import com.refinedmods.refinedstorage.api.network.impl.storage.StorageConfiguration;
import com.refinedmods.refinedstorage.api.resource.filter.FilterMode;
import com.refinedmods.refinedstorage.api.storage.AccessMode;
import com.refinedmods.refinedstorage.common.storage.AccessModeSettings;
import com.refinedmods.refinedstorage.common.storage.StorageConfigurationContainer;
import com.refinedmods.refinedstorage.common.support.FilterModeSettings;
import com.refinedmods.refinedstorage.common.support.FilterWithFuzzyMode;
import com.refinedmods.refinedstorage.common.support.RedstoneMode;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;

public final class StorageConfigurationContainerImpl
implements StorageConfigurationContainer {
    private static final String TAG_INSERT_PRIORITY = "pri";
    private static final String TAG_EXTRACT_PRIORITY = "epri";
    private static final String TAG_FILTER_MODE = "fim";
    private static final String TAG_ACCESS_MODE = "am";
    private static final String TAG_VOID_EXCESS = "ve";
    private final StorageConfiguration config;
    private final FilterWithFuzzyMode filter;
    private final Runnable listener;
    private final Supplier<RedstoneMode> redstoneModeSupplier;
    private final Consumer<RedstoneMode> redstoneModeConsumer;

    public StorageConfigurationContainerImpl(StorageConfiguration config, FilterWithFuzzyMode filter, Runnable listener, Supplier<RedstoneMode> redstoneModeSupplier, Consumer<RedstoneMode> redstoneModeConsumer) {
        this.config = config;
        this.filter = filter;
        this.listener = listener;
        this.redstoneModeSupplier = redstoneModeSupplier;
        this.redstoneModeConsumer = redstoneModeConsumer;
    }

    public void load(CompoundTag tag) {
        if (tag.contains(TAG_INSERT_PRIORITY)) {
            this.config.setInsertPriority(tag.getInt(TAG_INSERT_PRIORITY));
        }
        if (tag.contains(TAG_EXTRACT_PRIORITY)) {
            this.config.setExtractPriority(tag.getInt(TAG_EXTRACT_PRIORITY));
        } else {
            this.config.setExtractPriority(this.config.getInsertPriority());
        }
        if (tag.contains(TAG_FILTER_MODE)) {
            this.config.setFilterMode(FilterModeSettings.getFilterMode(tag.getInt(TAG_FILTER_MODE)));
        }
        if (tag.contains(TAG_ACCESS_MODE)) {
            this.config.setAccessMode(AccessModeSettings.getAccessMode(tag.getInt(TAG_ACCESS_MODE)));
        }
        if (tag.contains(TAG_VOID_EXCESS)) {
            this.config.setVoidExcess(tag.getBoolean(TAG_VOID_EXCESS));
        }
    }

    public void save(CompoundTag tag) {
        tag.putInt(TAG_FILTER_MODE, FilterModeSettings.getFilterMode(this.config.getFilterMode()));
        tag.putInt(TAG_INSERT_PRIORITY, this.config.getInsertPriority());
        tag.putInt(TAG_EXTRACT_PRIORITY, this.config.getExtractPriority());
        tag.putInt(TAG_ACCESS_MODE, AccessModeSettings.getAccessMode(this.config.getAccessMode()));
        tag.putBoolean(TAG_VOID_EXCESS, this.config.isVoidExcess());
    }

    @Override
    public int getInsertPriority() {
        return this.config.getInsertPriority();
    }

    @Override
    public void setInsertPriority(int insertPriority) {
        this.config.setInsertPriority(insertPriority);
        this.listener.run();
    }

    @Override
    public int getExtractPriority() {
        return this.config.getExtractPriority();
    }

    @Override
    public void setExtractPriority(int extractPriority) {
        this.config.setExtractPriority(extractPriority);
        this.listener.run();
    }

    @Override
    public FilterMode getFilterMode() {
        return this.config.getFilterMode();
    }

    @Override
    public void setFilterMode(FilterMode filterMode) {
        this.config.setFilterMode(filterMode);
        this.listener.run();
    }

    @Override
    public boolean isFuzzyMode() {
        return this.filter.isFuzzyMode();
    }

    @Override
    public void setFuzzyMode(boolean fuzzyMode) {
        this.filter.setFuzzyMode(fuzzyMode);
        this.listener.run();
    }

    @Override
    public AccessMode getAccessMode() {
        return this.config.getAccessMode();
    }

    @Override
    public void setAccessMode(AccessMode accessMode) {
        this.config.setAccessMode(accessMode);
        this.listener.run();
    }

    @Override
    public boolean isVoidExcess() {
        return this.config.isVoidExcess();
    }

    @Override
    public void setVoidExcess(boolean voidExcess) {
        this.config.setVoidExcess(voidExcess);
        this.listener.run();
    }

    @Override
    public RedstoneMode getRedstoneMode() {
        return this.redstoneModeSupplier.get();
    }

    @Override
    public void setRedstoneMode(RedstoneMode redstoneMode) {
        this.redstoneModeConsumer.accept(redstoneMode);
    }
}

