/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.storagemonitor;

import com.mojang.blaze3d.vertex.PoseStack;
import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import com.refinedmods.refinedstorage.common.api.RefinedStorageClientApi;
import com.refinedmods.refinedstorage.common.api.support.resource.PlatformResourceKey;
import com.refinedmods.refinedstorage.common.api.support.resource.ResourceRendering;
import com.refinedmods.refinedstorage.common.storagemonitor.StorageMonitorBlock;
import com.refinedmods.refinedstorage.common.storagemonitor.StorageMonitorBlockEntity;
import com.refinedmods.refinedstorage.common.support.direction.BiDirection;
import com.refinedmods.refinedstorage.common.support.direction.BiDirectionType;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import org.joml.Quaternionf;

public class StorageMonitorBlockEntityRenderer
implements BlockEntityRenderer<StorageMonitorBlockEntity> {
    private static final Quaternionf ROTATE_TO_FRONT = new Quaternionf().rotationY((float)Math.PI);
    private static final float FONT_SPACING = -0.23f;

    public void render(StorageMonitorBlockEntity blockEntity, float tickDelta, PoseStack poseStack, MultiBufferSource vertexConsumers, int light, int overlay) {
        Level level = blockEntity.getLevel();
        if (level == null) {
            return;
        }
        BiDirection direction = this.getDirection(blockEntity, level);
        if (direction == null) {
            return;
        }
        if (!blockEntity.isCurrentlyActive()) {
            return;
        }
        PlatformResourceKey resource = blockEntity.getConfiguredResource();
        if (resource == null) {
            return;
        }
        this.doRender(blockEntity.getLevel(), poseStack, vertexConsumers, direction, resource, blockEntity.getCurrentAmount());
    }

    private void doRender(Level level, PoseStack poseStack, MultiBufferSource vertexConsumers, BiDirection direction, ResourceKey resource, long amount) {
        ResourceRendering rendering = RefinedStorageClientApi.INSTANCE.getResourceRendering(resource.getClass());
        this.doRender(poseStack, vertexConsumers, direction.getQuaternion(), rendering.formatAmount(amount), level, rendering, resource);
    }

    private void doRender(PoseStack poseStack, MultiBufferSource renderTypeBuffer, Quaternionf rotation, String amount, Level level, ResourceRendering resourceRendering, ResourceKey resource) {
        poseStack.pushPose();
        poseStack.translate(0.5, 0.5, 0.5);
        poseStack.mulPose(rotation);
        poseStack.mulPose(ROTATE_TO_FRONT);
        poseStack.translate(0.0, 0.05, 0.5);
        poseStack.pushPose();
        this.renderAmount(poseStack, renderTypeBuffer, amount);
        poseStack.popPose();
        poseStack.pushPose();
        poseStack.translate(0.0f, 0.0f, 0.01f);
        resourceRendering.render(resource, poseStack, renderTypeBuffer, 0xF000F0, level);
        poseStack.popPose();
        poseStack.popPose();
    }

    private void renderAmount(PoseStack poseStack, MultiBufferSource renderTypeBuffer, String amount) {
        Font font = Minecraft.getInstance().font;
        float width = font.width(amount);
        poseStack.translate(0.0f, -0.23f, 0.02f);
        poseStack.scale(0.016129032f, -0.016129032f, 0.016129032f);
        poseStack.scale(0.5f, 0.5f, 0.0f);
        poseStack.translate(-0.5f * width, 0.0f, 0.5f);
        font.drawInBatch(amount, 0.0f, 0.0f, 0xFFFFFF, false, poseStack.last().pose(), renderTypeBuffer, Font.DisplayMode.NORMAL, 0, 0xF000F0);
    }

    @Nullable
    private BiDirection getDirection(StorageMonitorBlockEntity blockEntity, Level level) {
        BlockState state = level.getBlockState(blockEntity.getBlockPos());
        if (state.getBlock() instanceof StorageMonitorBlock) {
            return (BiDirection)((Object)state.getValue(BiDirectionType.INSTANCE.getProperty()));
        }
        return null;
    }
}

