/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.support.containermenu;

import com.refinedmods.refinedstorage.api.resource.ResourceAmount;
import com.refinedmods.refinedstorage.common.api.support.resource.PlatformResourceKey;
import com.refinedmods.refinedstorage.common.support.AbstractBaseContainerMenu;
import com.refinedmods.refinedstorage.common.support.containermenu.ResourceSlot;
import com.refinedmods.refinedstorage.common.support.packet.c2s.C2SPackets;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public abstract class AbstractResourceContainerMenu
extends AbstractBaseContainerMenu {
    @Nullable
    protected final Player player;
    private final List<ResourceSlot> resourceSlots = new ArrayList<ResourceSlot>();

    protected AbstractResourceContainerMenu(@Nullable MenuType<?> type, int syncId, Player player) {
        super(type, syncId);
        this.player = player;
    }

    protected AbstractResourceContainerMenu(@Nullable MenuType<?> type, int syncId) {
        super(type, syncId);
        this.player = null;
    }

    private Optional<ResourceSlot> getResourceSlot(int slotIndex) {
        if (slotIndex < 0 || slotIndex >= this.slots.size()) {
            return Optional.empty();
        }
        Object object = this.slots.get(slotIndex);
        if (object instanceof ResourceSlot) {
            ResourceSlot resourceSlot = (ResourceSlot)((Object)object);
            return Optional.of(resourceSlot);
        }
        return Optional.empty();
    }

    public void handleResourceSlotUpdate(int slotIndex, @Nullable ResourceAmount resourceAmount) {
        this.getResourceSlot(slotIndex).ifPresent(slot -> slot.change(resourceAmount));
    }

    public void handleResourceFilterSlotUpdate(int slotIndex, PlatformResourceKey resource) {
        this.getResourceSlot(slotIndex).ifPresent(slot -> slot.setFilter(resource));
    }

    public void handleResourceSlotChange(int slotIndex, boolean tryAlternatives) {
        this.getResourceSlot(slotIndex).ifPresent(slot -> slot.change(this.getCarried(), tryAlternatives));
    }

    public void sendResourceSlotChange(int slotIndex, boolean tryAlternatives) {
        C2SPackets.sendResourceSlotChange(slotIndex, tryAlternatives);
    }

    public void handleResourceSlotAmountChange(int slotIndex, long amount) {
        this.getResourceSlot(slotIndex).ifPresent(slot -> slot.changeAmount(amount));
    }

    public void broadcastChanges() {
        super.broadcastChanges();
        if (this.player == null) {
            return;
        }
        for (ResourceSlot resourceSlot : this.resourceSlots) {
            resourceSlot.broadcastChanges(this.player);
        }
    }

    public List<ResourceSlot> getResourceSlots() {
        return this.resourceSlots;
    }

    protected Slot addSlot(Slot slot) {
        if (slot instanceof ResourceSlot) {
            ResourceSlot resourceSlot = (ResourceSlot)slot;
            this.resourceSlots.add(resourceSlot);
        }
        return super.addSlot(slot);
    }

    @Override
    protected void resetSlots() {
        super.resetSlots();
        this.resourceSlots.clear();
    }

    public void addToResourceSlotIfNotExisting(ItemStack stack) {
        for (ResourceSlot resourceSlot : this.resourceSlots) {
            if (!resourceSlot.contains(stack)) continue;
            return;
        }
        for (ResourceSlot resourceSlot : this.resourceSlots) {
            if (!resourceSlot.changeIfEmpty(stack)) continue;
            return;
        }
    }

    protected final boolean areAllResourceSlotsEmpty() {
        for (ResourceSlot resourceSlot : this.resourceSlots) {
            if (resourceSlot.isEmpty()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean canTakeItemForPickAll(ItemStack stack, Slot slot) {
        if (slot instanceof ResourceSlot) {
            ResourceSlot resourceSlot = (ResourceSlot)slot;
            return resourceSlot.supportsItemSlotInteractions();
        }
        return super.canTakeItemForPickAll(stack, slot);
    }

    @Override
    public void clicked(int id, int dragType, ClickType clickType, Player p) {
        ItemStack result;
        ResourceSlot resourceSlot;
        Slot slot;
        Slot slot2 = slot = id >= 0 ? this.getSlot(id) : null;
        if (slot instanceof ResourceSlot && (resourceSlot = (ResourceSlot)slot).supportsItemSlotInteractions() && !resourceSlot.isEmpty() && !this.getCarried().isEmpty() && (result = resourceSlot.insertInto(this.getCarried())) != null) {
            this.setCarried(result);
            return;
        }
        super.clicked(id, dragType, clickType, p);
    }
}

