/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.support.energy;

import com.google.common.util.concurrent.RateLimiter;
import com.refinedmods.refinedstorage.common.support.packet.s2c.S2CPackets;
import com.refinedmods.refinedstorage.common.util.IdentifierUtil;
import java.util.Collections;
import java.util.List;
import java.util.function.LongSupplier;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

public class EnergyInfo {
    private final Player player;
    private final LongSupplier storedSupplier;
    private final LongSupplier capacitySupplier;
    private final RateLimiter rateLimiter = RateLimiter.create((double)4.0);
    private long stored;
    private long capacity;

    private EnergyInfo(ServerPlayer player, LongSupplier storedSupplier, LongSupplier capacitySupplier) {
        this.player = player;
        this.storedSupplier = storedSupplier;
        this.capacitySupplier = capacitySupplier;
        this.stored = storedSupplier.getAsLong();
        this.capacity = capacitySupplier.getAsLong();
    }

    private EnergyInfo(Player player, long stored, long capacity) {
        this.player = player;
        this.storedSupplier = () -> 0L;
        this.capacitySupplier = () -> 0L;
        this.stored = stored;
        this.capacity = capacity;
    }

    public void detectChanges() {
        boolean changed;
        long newStored = this.storedSupplier.getAsLong();
        long newCapacity = this.capacitySupplier.getAsLong();
        boolean bl = changed = this.stored != newStored || this.capacity != newCapacity;
        if (changed && this.rateLimiter.tryAcquire()) {
            this.setEnergy(newStored, newCapacity);
            S2CPackets.sendEnergyInfo((ServerPlayer)this.player, newStored, newCapacity);
        }
    }

    public void setEnergy(long newStored, long newCapacity) {
        this.stored = newStored;
        this.capacity = newCapacity;
    }

    public List<Component> createTooltip() {
        return Collections.singletonList(IdentifierUtil.createStoredWithCapacityTranslation(this.stored, this.capacity, this.getPercentageFull()));
    }

    public double getPercentageFull() {
        return (double)this.stored / (double)this.capacity;
    }

    public static EnergyInfo forServer(Player player, LongSupplier storedSupplier, LongSupplier capacitySupplier) {
        return new EnergyInfo((ServerPlayer)player, storedSupplier, capacitySupplier);
    }

    public static EnergyInfo forClient(Player player, long stored, long capacity) {
        return new EnergyInfo(player, stored, capacity);
    }
}

